let VentaActivity = function () {
    "use strict";

    let dom = App.getContainerMain();
    let clearButton;
    let domNumero, domLoteria, domMonto, domTableJugadas;
    let checkLoteriasOpenTimmer;

    let jugadaUpdate;

    let isJugadaUpdate = false;
    let isSPaleDefined = false;
    let isSPale = false;
    let typePaledDefined = 0;
    let isFromBackDefined = false;
    let fromBackOP = 0;
    let isCash3Defined = false;
    let isCash3Straight = false;
    let isPlay4Defined = false;
    let isPlay4Straight = false;
    let isMariageDefined = false;
    let isMariage = false;
    let isNumeroFijo = false;
    let isLoteriaFijo = false;
    let isMontoFijo = false;

    let ticket_uuid;

    let initHtml = function () {
        dom.empty();

        let html = '' +
            '<section class="box-typical box-vender">' +
            '   <header class="box-typical-header">' +
            '       <div class="tbl-row">' +
            '           <div class="tbl-cell tbl-cell-title"><h3>Vender</h3></div>' +
            '           <div class="tbl-cell tbl-cell-action-bordered" id="venta-icon-print"><button type="button" class="action-btn"><i class="fa fa-print" aria-hidden="true"></i></button></div>' +
            '           <div class="tbl-cell tbl-cell-action-bordered" id="venta-icon-clear" style="display: none"><button type="button" class="action-btn"><i class="fa fa-trash-o" aria-hidden="true"></i></button></div>' +
            //'           <div class="tbl-cell tbl-cell-action-bordered" id="venta-icon-none" style="display: none"><button type="button" class="action-btn"><i class="fa fa-external-link" aria-hidden="true"></i></button></div>' +
            '       </div>' +
            '   </header>' +
            '   <div class="box-typical-body">' +
            '       <div class="table-responsive">' +
            '           <table id="table_jugadas" class="table table-bordered table-hover table-sm" style="font-size:20px;">' +
            '               <thead>' +
            '                   <tr>' +
            '                       <th width="5%">#</th>' +
            '                       <th width="10%">PR</th>' +
            '                       <th>Jugada</th>' +
            '                       <th width="20%">Loteria</th>' +
            '                       <th width="15%">Monto</th>' +
            '                   </tr>' +
            '               </thead>' +
            '               <tbody></tbody>' +
            '               <tfoot>' +
            '                   <tr><th width="100%" colspan="5" style="text-align: right" id="jugadas_total_monto">$000</th></tr>' +
            '               </tfoot>' +
            '           </table>';

        dom.append(html);

        html = '' +
            '           <table class="table table-hover box-vender-bottom" id="box-vender-bottom" style="font-size:20px;">' +
            '               <thead>' +
            '                   <tr>' +
            '                       <th><input type="text" class="form-control" id="add_jugada_numero" placeholder="Jugada" va></th>' +
            '                       <th><input type="text" class="form-control" id="add_jugada_loteria" placeholder="Loteria"></th>' +
            '                       <th><div class="input-group"><div class="input-group-addon">$</div><input type="text" class="form-control" id="add_jugada_monto" placeholder="Monto">' +
            '                   </th>' +
            '                   </tr>' +
            '               </thead>' +
            '           </table>' +
            '       </div>' +
            '   </div>' +
            '</section>';

        dom.append(html);

        html = '<section class="box-typical loterias-logos">';
        let list = [];
        let loterias = Loterias.getList();
        loterias.forEach(function (loteria) {
            if (loteria.getTipo()) {
                if (loteria.isOpen()) {
                    list.push('<img id="v_loteria_'+loteria.getId()+'" src="img/loterias/'+loteria.getTipo()+'.jpg" class="activo">');
                }
                else {
                    list.push('<img id="v_loteria_'+loteria.getId()+'" src="img/loterias/'+loteria.getTipo()+'.jpg" class="inactivo">');
                }
            }
        });

        html += list.join('<hr>');

        html += '</section>';
        dom.append(html);

        clearButton = $('#venta-icon-clear');

        // click en los logos de las loterias
        loterias.forEach(function (loteria) {
            if (loteria.getTipo()) {
                dom.find('#v_loteria_'+loteria.getId()).click(function() {
                    if (loteria.isOpen()) {
                        domLoteria.val(loteria.getAbreviado());
                        domLoteria.prop('readonly', true);
                        isLoteriaFijo = true;
                    }
                });
            }
        });

        // revision periodica de loterias abiertas/cerradas
        clearTimeout(checkLoteriasOpenTimmer);
        checkLoteriasOpen();
    }

    let checkLoteriasOpen = function() {
        clearTimeout(checkLoteriasOpenTimmer);

        if (!App.isActivePage(Co.PAGE_VENDER)) {
            return;
        }

        let loterias = Loterias.getList();
        loterias.forEach(function (loteria) {
            if (loteria.getTipo()) {
                if (loteria.isOpen()) {
                    dom.find('#v_loteria_'+loteria.getId()).removeClass('inactivo').addClass('activo');
                }
                else {
                    dom.find('#v_loteria_'+loteria.getId()).removeClass('activo').addClass('inactivo');
                }
            }
        });

        checkLoteriasOpenTimmer = setTimeout(function () {
            checkLoteriasOpen();
        },300000);
    }

    let initListeners = function () {
        domTableJugadas = $('#table_jugadas tbody');
        domLoteria = $('#add_jugada_loteria');
        domNumero = $('#add_jugada_numero');
        domMonto = $('#add_jugada_monto');

        $('#table_jugadas').on('click', 'tbody tr', function () {
            let trID = $(this).attr('id');
            let position = parseInt(ut.only_number(trID)) - 1;

            let html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-ticketNewJugadaAction">';
            html += '<li id="edit"><a href="#link">'+ _t('edit') +'</a></li>';
            html += '<li id="delete"><a href="#link">'+ _t('delete') +'</a></li>';
            html += '</ul>';

            $.confirm({
                backgroundDismiss: true,
                title: '',
                content: html,
                buttons: {
                    buttonA: {isHidden: true},
                    buttonB: {isHidden: true}
                },
                onContentReady: function () {
                    let modal = this;

                    $('ul#dialog-ticketNewJugadaAction li').keynavigator({
                        activeClass: 'alert-info',
                        keys: {
                            enter: function($el) {
                                let op_selected = $el.attr('id');
                                modal.close();

                                if (op_selected == 'edit') {
                                    updateJugada(position);
                                }
                                else if (op_selected == 'delete') {
                                    deleteJugada(position);
                                }
                            }
                        }
                    });

                    $('ul#dialog-ticketNewJugadaAction li:eq(0)').click();
                }
            });
        });

        clearButton.click(function (event) {
            removeAll();
        })

        domNumero.keypress(function (e) {
            if(e.which == 13) {

                let numero = $(this).val();
                if (!VentaUtils.validarNumeric(numero)) {
                    ui.dialogError(_t('invalid_jugada'));
                    return;
                }

                if (e.shiftKey) {
                    domNumero.prop('readonly', true);
                    isNumeroFijo = true;
                }

                if (!isLoteriaFijo) {
                    setFocusLoteria();
                }
                else if (!isMontoFijo) {
                    setFocusMonto();
                }
                else {
                    addJugadaEval();
                }
            }
        });

        domNumero.click(function (e) {
            isNumeroFijo = false;
            domNumero.prop('readonly', false);
            setFocusNumero(true);
        });

        domLoteria.keypress(function (e) {
            if (e.which == 13) {
                let value = $(this).val();

                if (VentaUtils.hasElegirLoteria()) {
                    if (!VentaUtils.validarLoteriaByAbreviado(value)) {
                        ui.dialogErrorSimple(_t('ticket_invalid_loteria'));
                    }
                }
                else {
                    if (!VentaUtils.validarLoteriaByCode(value)) {
                        ui.dialogErrorSimple(_t('ticket_invalid_loteria'));
                        return;
                    }

                    if (e.shiftKey) {
                        domLoteria.prop('readonly', true);
                        isLoteriaFijo = true;
                    }
                }

                if (!isMontoFijo) {
                    setFocusMonto();
                }
                else {
                    addJugadaEval();
                }
            }
        });

        domLoteria.click(function (e) {
            isLoteriaFijo = false;
            domLoteria.prop('readonly', false);
            setFocusLoteria(true);
        });

        domLoteria.blur(function (e) {
            if (VentaUtils.hasElegirLoteria()) {

            }
            else {
                domLoteria.val(Loterias.getAbreviadosFromCodigos(getValorLoteria()));
            }
        });

        domMonto.keypress(function (e) {
            if (e.which == 13) {
                let value = $(this).val();
                if (!VentaUtils.validarMonto(value)) {
                    ui.dialogErrorSimple(_t('ticket_invalid_valor'));
                    return;
                }

                if (e.shiftKey) {
                    domMonto.prop('readonly', true);
                    isMontoFijo = true;
                }

                addJugadaEval();
            }
        });

        domMonto.click(function (e) {
            isMontoFijo = false;
            domMonto.prop('readonly', false);
            setFocusMonto(true);
        });
    }

    // eliminar jugada
    let deleteJugada = function(position) {
        Jugadas.remove(position);
        reload();
    }

    // modificar jugada
    let updateJugada = function(position) {
        let jugada = Jugadas.get(position);
        domNumero.val(jugada.getNumero());
        domLoteria.val(jugada.getLoteriasAbreviado());
        domMonto.val(jugada.getValor());

        isJugadaUpdate = true;
        jugadaUpdate = jugada;

        if (VentaUtils.isPale(jugada.getNumero()) && jugada.countLoterias() == 2) {
            //typePaledDefined = 0;

            isSPaleDefined = false;
            isSPale = false;
        }

        setFocusNumero();
    }

    let addJugadaEval = function() {
        let numero = getValNumero();
        let loteria = getValorLoteria();
        let monto = getValorMonto();
        let jugstr, loteriaModel;

        // validamos loteria
        if (validator.isNumeric(loteria)) {
            // si es codigo
            if (!VentaUtils.validarLoteriaByCode(loteria)) {
                setFocusLoteria();
                ui.dialogErrorSimple(_t('ticket_invalid_loteria'));
                return;
            }

            if (!VentaUtils.validarLoteriaCierreByCode(loteria)) {
                setFocusLoteria();
                return;
            }

            loteriaModel = Loterias.getFirstFromCodigos(loteria);
        }
        else {
            // si es abreviado
            if (!VentaUtils.validarLoteriaByAbreviado(loteria)) {
                setFocusLoteria();
                ui.dialogErrorSimple(_t('ticket_invalid_loteria'));
                return;
            }

            if (!VentaUtils.validarLoteriaCierreByAbreviado(loteria)) {
                setFocusLoteria();
                return;
            }

            loteriaModel = Loterias.getFirstFromAbreviados(loteria);
        }

        // validamos numero
        if (!VentaUtils.validarNumero(numero, loteria)) {
            setFocusNumero();
            ui.dialogErrorSimple(_t('invalid_jugada'));
            return;
        }

        // validamos valor
        if (!VentaUtils.validarMonto(monto)) {
            setFocusMonto();
            ui.dialogErrorSimple(_t('ticket_invalid_valor'));
            return;
        }

        // checamos tipo de jugada (jugstr)
        if (loteriaModel.isAmericana()) {
            if (VentaUtils.isFromBack(numero)) {
                if (!isFromBackDefined) {
                    Modal.ventaDefineFromBack();
                    return;
                }

                jugstr = fromBackOP;
            }
            else if (VentaUtils.isCash3(numero)) {
                if (!isCash3Defined) {
                    Modal.ventaDefineCash3();
                    return;
                }

                if (isCash3Straight) {
                    jugstr = Jugadas.CASH3_STRAIGHT;
                }
                else {
                    jugstr = Jugadas.CASH3_BOX;
                }
            }
            else if (VentaUtils.isPlay4(numero)) {
                if (!isPlay4Defined) {
                    Modal.ventaDefinePlay4()
                    return;
                }

                if (isPlay4Straight) {
                    jugstr = Jugadas.PLAY4_STRAIGHT;
                }
                else {
                    jugstr = Jugadas.PLAY4_BOX;
                }
            }
        }
        else if (loteriaModel.isCash3()) {
            if (!isCash3Defined) {
                Modal.ventaDefineCash3();
                return;
            }

            if (isCash3Straight) {
                jugstr = Jugadas.CASH3_STRAIGHT;
            }
            else {
                jugstr = Jugadas.CASH3_BOX;
            }
        }
        else if (loteriaModel.isPlay4()) {
            if (!isPlay4Defined) {
                Modal.ventaDefinePlay4()
                return;
            }

            if (isPlay4Straight) {
                jugstr = Jugadas.PLAY4_STRAIGHT;
            }
            else {
                jugstr = Jugadas.PLAY4_BOX;
            }
        }
        else if (loteriaModel.isBorlette()) {
            if (VentaUtils.isMariage(numero)) {
                if (!isMariageDefined) {
                    Modal.ventaDefineMariage()
                    return;
                }

                if (isMariage) {
                    jugstr = Jugadas.MARIAGE;
                }
                else {
                    jugstr = Jugadas.LOTO4;
                }
            }
            else if (VentaUtils.isBorlette(numero)) {
                jugstr = Jugadas.BORLETTE;
            }
            else if (VentaUtils.isLoto3(numero)) {
                jugstr = Jugadas.LOTO3;
            }
            else if (VentaUtils.isLoto4(numero)) {
                jugstr = Jugadas.LOTO4;
            }
            else if (VentaUtils.isLoto5(numero)) {
                jugstr = Jugadas.LOTO5;
            }
            else if (VentaUtils.isLoto6(numero)) {
                jugstr = Jugadas.LOTO6;
            }
        }
        // checamos si es quiniela
        else if (VentaUtils.isQuiniela(numero)) {
            jugstr = Jugadas.QUINIELA;
        }
        // checamos si es pale o super pale
        else if (VentaUtils.isPale(numero)) {

            // checamos las loterias
            let loteriasCheck = [];
            if (validator.isNumeric(loteria)) {
                loteriasCheck = Loterias.getFromCodigos(loteria);
            }
            else {
                loteriasCheck = Loterias.getFromAbreviados(loteria);
            }

            // si hay dos loterias, preguntamos si es pale o spale
            if (loteriasCheck.length == 2) {

                // si no se ha definido si es pale o spale, hay que definirlo
                if (!isSPaleDefined) {
                    Modal.ventaDefinePale();
                    return;
                }

                if (isSPale) {
                    jugstr = Jugadas.SUPER_PALE;
                }
                else {
                    jugstr = Jugadas.PALE;
                }
            }
            else {
                jugstr = Jugadas.PALE;
            }
        }
        else if (VentaUtils.isTripleta(numero)) {
            jugstr = Jugadas.TRIPLETA;
        }

        if (isJugadaUpdate) {
            jugadaUpdate.setNumero(numero);
            jugadaUpdate.setValor(monto);
            jugadaUpdate.setJugstr(jugstr);

            if (validator.isNumeric(loteria)) {
                loteria = Loterias.getIdsFromCodigos(loteria);
            }
            else {
                loteria = Loterias.getIdsFromAbreviados(loteria);
            }

            jugadaUpdate.setLoteria(loteria);

            addJugada(null);
        }
        else {
            if (validator.isNumeric(loteria)) {
                loteria = Loterias.getIdsFromCodigos(loteria);
            }
            else {
                loteria = Loterias.getIdsFromAbreviados(loteria);
            }

            let jugada = new Jugada(numero, loteria, monto, jugstr);

            // checamos que la jugada no exista, para evitar duplicado
            let jugada_check = Jugadas.existe(jugada);
            if (!jugada_check) {
                addJugada(jugada);
            }
            else {
                // si existe, sumamos los valores
                jugada_check.setValor(jugada_check.getValor2() + jugada.getValor2());
                addJugada(null);
            }
        }

        // reseteamos los flags
        isJugadaUpdate = false;
        isSPaleDefined = false;
        isSPale = false;
        isCash3Defined = false;
        isCash3Straight = false;
        isPlay4Defined = false;
        isPlay4Straight = false;
        isMariageDefined = false;
        isFromBackDefined = false;
        isMariage = false;
    }

    let setFocusNumero = function() { console.log("setFocusNumero()")
        domNumero.focus();
    }

    let setFocusLoteria = function(clicked) { console.log("setFocusLoteria()")
        console.log("VentaUtils.hasElegirLoteria():"+VentaUtils.hasElegirLoteria());
        if (VentaUtils.hasElegirLoteria()) {
            if (validator.isEmpty(getValorLoteria()) || clicked) {
                openModalElegirLoteria();
            }
            else {
                setFocusMonto();
            }
        }
        else {
            let codigos = Loterias.getCodigosFromAbreviados(getValorLoteria()); console.log("codigos: " + codigos);
            domLoteria.val(codigos);
            domLoteria.focus();
        }
    }

    let setFocusMonto = function() { console.log("setFocusMonto()")
        domMonto.focus();
    }

    let getValNumero = function() {
        return domNumero.val().trim();
    }

    let getValorLoteria = function() {
        return domLoteria.val().trim();
    }

    let getValorMonto = function() {
        let m = domMonto.val().trim();
        m = parseFloat(m);
        m = ut.round(m, 1);
        m = parseFloat(m);
        return m.toFixed(1);
    }

    let addJugada = function (jugada) { //console.log("venta.addJugada()");
        if (jugada) {
            Jugadas.add(jugada);
        }
        reload();

        if (!isNumeroFijo) {
            domNumero.val('');
        }

        if (!isLoteriaFijo && !VentaUtils.hasElegirLoteria()) {
            domLoteria.val('');
        }

        if (!isMontoFijo) {
            domMonto.val('');
        }

        if (!isNumeroFijo) {
            domNumero.focus();
        }
        else if (!isLoteriaFijo && !VentaUtils.hasElegirLoteria()) {
            domLoteria.focus();
        }
        else if (!isMontoFijo) {
            domMonto.focus();
        }


    }

    let send = function () {

        // si no hay ninguna jugada
        if (Jugadas.size() == 0) {
            ui.dialogError(_t('ticket_sin_jugadas'));
            return;
        }

        // si no hay ninguna jugada
        if (Jugadas.size() == 0) {
            ui.dialogError(_t('ticket_sin_jugadas'));
            return;
        }

        let jugadas = [];
        Jugadas.getAll().forEach(function (jugada) {
            jugadas.push({
                numero: jugada.getNumero(),
                loteria: jugada.getLoteria(),
                valor: jugada.getValor().toString(),
                jugstr: jugada.getJugstr()
            });
        });

        let data = {
            'action': packet.VENDER,
            'uuid': ticket_uuid,
            'type_venta': "printer",
            'count': Jugadas.size(),
            'jugadas': jugadas
        }

        ui.loadingStart(_t('ticket_sending'));
        Server.send(data);
    }

    let reload = function () { //console.log("VentaActivity.reload()");
        domTableJugadas.empty();

        let html;
        let jugadas = Jugadas.getAll();
        jugadas.forEach(function (jugada, index) {
            index = index+1;
            html = '<tr id="tr_venta_' +index+ '">' +
                '<td>' + index + '</td>' +
                '<td>' + jugada.getJugstr() + '</td>' +
                '<td>' + jugada.getNumero2() + '</td>' +
                '<td>' + jugada.getLoteriasAbreviado() + '</td>' +
                '<td style="text-align: right">' + jugada.getValor() + '</td>' +
                '</tr>';

            domTableJugadas.append(html);
        });

        $('#jugadas_total_monto').text('$ ' + Jugadas.totalMonto().formatMoney(2, '.', ','));

        if (jugadas.length > 0) {
            clearButton.show();
        }
        else {
            clearButton.hide();
        }

        let d = $('.table-responsive');
        d.scrollTop(d.prop("scrollHeight"));
    }

    let checkOffset = function() {
        let offset = $('#box-vender-bottom').offset(); //console.log(offset); console.log("left:" + offset.left + " top:"+offset.top);
    }

    let reloadFromCopy = function(rows) {
        Jugadas.reset();

        let j;
        for (let i=0; i<rows.length; i++) {
            j = rows[i];
            addJugada(new Jugada(j.numero, j.loteria, j.valor, j.jugstr));
        }

        addJugada(null);
    }

    let reloadFromCombinar = function(rows) {
        let j;
        for (let i=0; i<rows.length; i++) {
            j = rows[i];
            addJugada(new Jugada(j.numero, j.loteria, j.valor, j.jugstr));
            //console.log(new Jugada(j.numero, j.loteria, j.valor, j.jugstr));
        }

        addJugada(null);
    }

    let openModalElegirLoteria = function() { console.log("VentaFragment.openModalElegirLoteria(): " + Time.getHHMM());
        const loterias = Loterias.getList();
        let abreviados = [];
        loterias.forEach(function(loteria) {
            if (loteria.isOpen()) {
                abreviados.push(loteria.getAbreviado());
            }
        });

        if (abreviados.length == 0) {
            ui.dialogError("Todas las loterías están cerradas.", "Loterías cerradas!");
            return;
        }

        // checamos si hay valores ingresados
        let loteria;
        let loterias_pre_selected = [];
        if (!validator.isEmpty(getValorLoteria())) {
            let abreviados = getValorLoteria().split(' ');
            if (abreviados.length > 0) {
                for (let i=0; i<abreviados.length; i++) {
                    //console.log(abreviados[i]);
                    loteria = Loterias.getFromAbreviado(abreviados[i]);
                    loterias_pre_selected.push(Loterias.getFromAbreviado(abreviados[i]).getId());
                }
            }
        }

        let selected = false;
        let html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-menu">';

        // checamos si hay varias loterias abiertas
        let abiertas = 0;
        let abiertasSelected = 0;
        loterias.forEach(function (loteria) {
            if (loteria.isOpen()) { abiertas++; }
            if (loterias_pre_selected.indexOf(loteria.getId()) >= 0) { abiertasSelected++; }
        });

        // si hay mas de una loteria abierta, mostramos opcion para seleccionar todas
        if (abiertas > 1) {
            html += '<li id="0">' +
                '<div class="checkbox"><input type="checkbox" id="check-0" ' + (abiertas==abiertasSelected ? 'checked' : '') + '>' +
                '<label for="check-0">Todas</label>' +
                '</div></li>';
        }

        loterias.forEach(function (loteria) {
            if (!loteria.isOpen()) { return; }

            selected = false;
            if (loterias_pre_selected.indexOf(loteria.getId()) >= 0) {
                selected = true;
            }

            html += '<li id="'+loteria.getId()+'">' +
                '<div class="checkbox"><input type="checkbox" id="check-'+loteria.getId()+'" '+(selected?'checked':'')+'>' +
                '<label for="check-'+loteria.getId()+'">'+loteria.getNombre()+'</label>' +
                '</div></li>';
        });
        html += '</ul>';

        $.confirm({
            useBootstrap: false,
            backgroundDismiss: true,
            title: 'Seleccione la Lotería',
            content: html,
            buttons: {
                buttonA: {isHidden: true},
                buttonB: {isHidden: true}
            },
            onContentReady: function () {
                let modal = this;

                $('ul#dialog-menu li').keynavigator({
                    activeClass: 'alert-info',
                    keys: {
                        enter: function($el) {
                            modal.close();

                            let loterias_selected = [];
                            let elements = $el.parent().find(':checkbox');
                            Object.values(elements).forEach(function(element) {
                                element = $(element);
                                if (element.prop('checked')) {
                                    if (element.attr('id') != 'check-0') {
                                        loterias_selected.push(filter.number(element.attr('id')));
                                    }
                                }
                            });
                            loterias_selected = loterias_selected.unique();

                            let loterias_str = [];
                            loterias_selected.forEach(function (id) {
                                loterias_str.push(Loterias.get(id).getAbreviado());
                            });

                            domLoteria.val(loterias_str.join(' '));
                            domLoteria.prop('disabled', true);
                            domNumero.prop('disabled', true);
                            setFocusMonto();
                            setTimeout(function () {
                                setFocusMonto();
                                domNumero.prop('disabled', false);
                                domLoteria.prop('disabled', false);
                            },1000);
                        },
                        107: function($el) {
                            if ($el.attr("id") === '0') {
                                $el.find(':checkbox').closest("ul").find(':checkbox').prop('checked', !$el.find(':checkbox').prop('checked'));
                            }
                            else {
                                $el.find(':checkbox').prop('checked', !$el.find(':checkbox').prop('checked'));
                                if (!$el.find(':checkbox').prop('checked')) {
                                    $('#check-0').prop('checked', false);
                                }
                            }
                        }
                    }
                });

                $('ul#dialog-menu li:eq(0)').click();

                $('ul#dialog-menu li').find(':checkbox').click(function (e) {
                    let el = $(this);
                    if (el.attr('id') === 'check-0') {
                        el.closest("ul").find(':checkbox').prop('checked', el.prop('checked'));
                    }
                    else {
                        if (!el.prop('checked')) {
                            $('#check-0').prop('checked', false);
                        }
                    }
                })
            }
        })
    }

    let removeAll = function (ticket) {
        $.confirm({
            title: '¿Eliminar todas las jugadas?',
            content: "Se eliminarán las jugadas que hay en pantalla",
            buttons: {
                cancel: function () {},
                confirm: {
                    text: 'Sí, proceder',
                    btnClass: 'btn-blue',
                    keys: ['enter'],
                    action: function() {
                        Jugadas.reset();
                        reload();
                    }
                }
            }
        });
    }

    let venderResult = function(data) { console.log("VentaActivity.venderResult()");
        ui.loadingStop();

        if (data.success) {
            // si no hay jugadas, no se imprime nada
            if (Jugadas.size() > 0) {
                new PrinterTicket(data.data).print();
                Jugadas.reset();
                reload();
                resetUUID();
            }
        }
        else {
            ui.dialogError(data.msg);
        }
    }

    let resetUUID = function () {
        ticket_uuid = ut.getTicketUUID();
    }

    let init = function () {
        if (!App.isActivePage(Co.PAGE_VENDER)) {
            App.setCurrentPage(Co.PAGE_VENDER);

            initHtml();
            initListeners();
            setFocusNumero();
            resetUUID();
            setFocusNumero();
        }
    }

    return {
        init: init,
        send: send,
        checkOffset: checkOffset,
        reloadFromCopy: reloadFromCopy,
        reloadFromCombinar: reloadFromCombinar,
        venderResult: venderResult,
        definePale: function (_isSPale) {
            isSPaleDefined = true;
            isSPale = _isSPale;
            addJugadaEval();

            setTimeout(function () {
                if (!domNumero.val()) {
                    setFocusNumero();
                }
            },1000);
        },
        defineCash3: function (isStraight) {
            isCash3Defined = true;
            isCash3Straight = isStraight;
            addJugadaEval();

            setTimeout(function () {
                if (!domNumero.val()) {
                    setFocusNumero();
                }
            },1000);
        },
        definePlay4: function (isStraight) {
            isPlay4Defined = true;
            isPlay4Straight = isStraight;
            addJugadaEval();

            setTimeout(function () {
                if (!domNumero.val()) {
                    setFocusNumero();
                }
            },1000);
        },
        defineMariage: function (_isMariage) {
            isMariageDefined = true;
            isMariage = _isMariage;
            addJugadaEval();

            setTimeout(function () {
                if (!domNumero.val()) {
                    setFocusNumero();
                }
            },1000);
        },
        defineFromBack: function (op) {
            isFromBackDefined = true;
            fromBackOP = op;
            addJugadaEval();

            setTimeout(function () {
                if (!domNumero.val()) {
                    setFocusNumero();
                }
            },1000);
        },
    }
}();