let Time = {

    HORA_SEGUNDOS: 3600,
    DIA_SEGUNDOS: 86400,
    TIMEZONE: 'America/Santo_Domingo',

    setTimeZone: function (timezone) {
        if  (timezone) {
            this.TIMEZONE = timezone;
        }
    },

    meses_short: {
        '01':'Ene', '02':'Feb', '03':'Mar', '04':'Abr', '05': 'May', '06': 'Jun', '07': 'Jul', '08': 'Ago', '09': 'Sep', '10': 'Oct', '11': 'Nov', '12': 'Dic'
    },
    dias: {
        '1':'lunes', '2':'martes', '3':'miercoles', '4':'jueves', '5': 'viernes', '6': 'sabado', '7': 'domingo'
    },

    suma_dias: function(fecha,dias) {
        let date = new Date(fecha + 'T00:00:00Z');
        date.setTime( date.getTime() + dias * 86400000 );

        let dd = ("0" + date.getDate()).slice(-2);
        let mm = ("0" + (date.getMonth() + 1)).slice(-2);
        let y = date.getFullYear();

        return y + '-'+ mm + '-'+ dd;
    },

    resta_dias: function(fecha,dias) {
        let date = new Date(fecha + 'T12:00:00Z');
        date.setTime( date.getTime() - dias * 86400000 );

        let dd = ("0" + date.getDate()).slice(-2);
        let mm = ("0" + (date.getMonth() + 1)).slice(-2);
        let y = date.getFullYear();

        return y + '-'+ mm + '-'+ dd;
    },

    fecha: function(format, fecha) {
        if (!format) {
            format = "YYYY-MM-DD HH:mm:ss";
        }

        if (fecha) {
            return moment(fecha, "YYYY-MM-DD HH:mm:ss").tz(this.TIMEZONE).format(format);
        }
        else {
            return moment().tz(this.TIMEZONE).format(format);
        }
    },

    hora: function() {
        return moment().tz(this.TIMEZONE).format("HH:mm:ss");
    },

    segundos: function() {
        return Math.round(moment().tz(this.TIMEZONE).valueOf() / 1000);
    },

    fecha_dia: function() {
        return moment().tz(this.TIMEZONE).format("YYYY-MM-DD");
    },

    fecha_dia2: function() {
        return moment().tz(this.TIMEZONE).format("DD-MM-YYYY");
    },

    day_num: function() {
        return moment().tz(this.TIMEZONE).format("E");
    },

    day_name: function() {
        let day_num = this.day_num();
        return this.dias[day_num];
    },

    getHHMM: function () {
        return moment().tz(this.TIMEZONE).format("HH:mm");
    },

    hms_to_seconds: function(str) {
        let p = str.split(':'),
            s = 0, m = 1;

        while (p.length > 0) {
            s += m * parseInt(p.pop(), 10);
            m *= 60;
        }

        return s;
    },

    fecha_to_timestamp: function (fecha) {
        return moment(fecha, "YYYY-MM-DD HH:mm:ss").tz(this.TIMEZONE).valueOf();
    },

    fecha_to_time: function (fecha) {
        return Math.round(moment(fecha, "YYYY-MM-DD HH:mm:ss").tz(this.TIMEZONE).valueOf() / 1000);
    },

    dateToFecha: function (date, format) {
        //format = format | "YYYY-MM-DD HH:mm:ss";
        if (!format) {
            format = "YYYY-MM-DD HH:mm:ss";
        }

        return moment(date, "YYYY-MM-DD HH:mm:ss").tz(this.TIMEZONE).format(format);
    },

    fechaTicketPrint: function() {
        let fecha = this.fecha();
        let rr = fecha.split(/[\s\-:]+/);
        let year = rr[0];
        let month = rr[1];
        let day = rr[2];
        let h = rr[3];
        let m = rr[4];
        let s = rr[5];

        let ampm = parseInt(h) >= 12 ? 'PM' : 'AM';

        h = parseInt(h) % 12;
        h = h ? h : 12; // the hour '0' should be '12'
        if (h < 10) { h = '0'+h; }

        fecha = day + "/" + time.meses_short[month] + "/" + year + " " + h + ":" + m + " " + ampm;
        return fecha;
    },

    hmsTo12Hr: function(time) { //console.log("timeTo12Hr() seconds:"+time);
        time = time.toString ().match (/^([01]\d|2[0-3])(:)([0-5]\d)(:[0-5]\d)?$/) || [time];

        if (time.length > 1) { // If time format correct
            time = time.slice (1);  // Remove full string match value
            time[5] = +time[0] < 12 ? 'AM' : 'PM'; // Set AM/PM
            time[0] = +time[0] % 12 || 12; // Adjust hours
        }

        return time.join (''); // return adjusted time or original string
    },

    formatChatTimeFecha: function(fecha) { //console.log("formatChatTimeFecha(): " + fecha)
        let chat_time = this.fecha_to_time(fecha); //console.log("chat_time: " + chat_time)
        let current_time = this.segundos(); //console.log("current_time: " + current_time)

        let datediff = current_time - chat_time; //console.log("datediff: " + datediff)

        if(datediff < this.DIA_SEGUNDOS) { // hoy
            //console.log("es hoy")
            return moment(fecha).tz(this.TIMEZONE).format("h:mm a").valueOf();
        }
        else if(datediff < (this.DIA_SEGUNDOS * 2)) { // ayer
            //console.log("es ayer")
            return "Ayer " + moment(fecha).tz(this.TIMEZONE).format("h:mm a").valueOf();
        }
        else {
            //console.log("es otro dia")
            return moment(fecha).tz(this.TIMEZONE).format("DD/MM/YY - h:mm a").valueOf();
        }
    }
}