let Modal = function () {

    let configMenu = function () {
        let html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-config_menu">';
            //html += '<li id="_op_config_printer"><a href="#link">'+ _t('op_config_printer') +'</a></li>';
            //html += '<li id="_op_config_pass"><a href="#link">'+ _t('op_config_pass') +'</a></li>';
            html += '<li id="_op_config_theme"><a href="#link">'+ _t('op_config_theme') +'</a></li>';
            //html += '<li id="_op_config_config"><a href="#link">'+ _t('op_config_config') +'</a></li>';
            html += '</ul>';

        $.confirm({
            useBootstrap: false,
            backgroundDismiss: true,
            title: '',
            content: html,
            buttons: {
                buttonA: {
                    isHidden: true
                },
                buttonB: {
                    isHidden: true
                }
            },
            onContentReady: function () {
                let modal = this;

                $('ul#dialog-config_menu li').keynavigator({
                    activeClass: 'alert-info',
                    keys: {
                        enter: function($el) {
                            let op_selected = $el.attr('id'); console.log(op_selected)
                            modal.close();

                            if (op_selected == '_op_config_printer') {
                                $(".colorPickSelector").click();
                            }
                            else if (op_selected == '_op_config_theme') {
                                $(".colorPickSelector").click();
                            }
                            else if (op_selected == '_op_config_config') {
                                configJugadas();
                            }
                        }
                    }
                });

                $('ul#dialog-config_menu li:eq(0)').click();
            }
        });
    }

    let configJugadas = function () {
        let html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-menu">';
        html += '<li id="_op_seleccion_loterias"><a href="#link">Selección de loterías</a></li>';
        html += '</ul>';

        $.confirm({
            useBootstrap: false,
            backgroundDismiss: true,
            title: 'Configuración',
            content: html,
            buttons: {
                buttonA: {
                    isHidden: true
                },
                buttonB: {
                    isHidden: true
                }
            },
            onContentReady: function () {
                let modal = this;

                $('ul#dialog-menu li').keynavigator({
                    activeClass: 'alert-info',
                    keys: {
                        enter: function($el) {
                            let op_selected = $el.attr('id'); console.log(op_selected)
                            modal.close();

                            if (op_selected == '_op_seleccion_loterias') {
                                configJugadasSeleccionLoterias();
                            }
                        }
                    }
                });

                $('ul#dialog-menu li:eq(0)').click();
            }
        });
    }

    let configJugadasSeleccionLoterias = function () {
        let op_index = DB.get(DB.CONFIG_JUGADA_SELECCION_LOTERIA);

        let html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-menu">';
        html += '<li id="'+Co.CONFIG_JUGADA_SELECCION_LOTERIA_CODIGO+'"><a href="#link">Usar Códigos</a></li>';
        html += '<li id="'+Co.CONFIG_JUGADA_SELECCION_LOTERIA_SELECCION+'"><a href="#link">Seleccionar Loterías</a></li>';
        html += '</ul>';

        $.confirm({
            escapeKey: true,
            backgroundDismiss: true,
            useBootstrap: false,
            title: 'Selección de loterías',
            content: html,
            buttons: {
                buttonA: {
                    isHidden: true
                },
                buttonB: {
                    isHidden: true
                }
            },
            onContentReady: function () {
                let modal = this;

                $('ul#dialog-menu li').keynavigator({
                    activeClass: 'alert-info',
                    tabindex: 1,
                    keys: {
                        enter: function($el) {
                            let op_selected = $el.attr('id'); console.log(op_selected)
                            DB.set(DB.CONFIG_JUGADA_SELECCION_LOTERIA, op_selected);
                            modal.close();
                        }
                    }
                });

                if (op_index === Co.CONFIG_JUGADA_SELECCION_LOTERIA_SELECCION) {
                    $('ul#dialog-menu li:eq(1)').click();
                }
                else {
                    $('ul#dialog-menu li:eq(0)').click();
                }
            }
        });
    }

    let pagar = function () {
        $.confirm({
            escapeKey: true,
            backgroundDismiss: true,
            title: _t('ticket_modal_pagar'),
            content: '<div class="form-group"><input type="text" placeholder="Ticket No." class="input-ticket form-control"/></div>',
            buttons: {
                formSubmit: {
                    text: _t('accept'),
                    btnClass: 'btn-blue',
                    action: function () {
                        let jc = this;
                        let element = jc.$content.find('.input-ticket');
                        let ticket = element.val();
                        /*if (!ticket) {
                            jc.close();
                            return false;
                        }*/

                        if (ticket.length < 8) {
                            ui.dialogErrorSimple(_t('ticket_invalido'), function(){element.focus();});
                            return false;
                        }

                        Server.send({
                            'action': packet.PAGAR,
                            'ticket': ticket
                        });
                    }
                },
                cancel: function () {
                    //close
                },
            },
            onContentReady: function () {
                // bind to events
                let jc = this;
                let element = jc.$content.find('.input-ticket');
                element.on('keypress', function (e) {
                    if (e.which == 13) {
                        e.preventDefault();
                        jc.$$formSubmit.trigger('click');
                    }
                });

                element.focus();
            }
        });
    }

    let pagarCodigo = function (ticket) {
        $.confirm({
            title: _t('ticket_modal_pagar'),
            content: '<div class="form-group"><input type="text" placeholder="Código" class="input-ticket form-control"/></div>',
            buttons: {
                formSubmit: {
                    text: _t('accept'),
                    btnClass: 'btn-blue',
                    action: function () {
                        let jc = this;
                        let element = jc.$content.find('.input-ticket');
                        let codigo = element.val();
                        /*if (!codigo) {
                            jc.close();
                            return false;
                        }*/

                        if (codigo.length != 4) {
                            ui.dialogErrorSimple(_t('ticket_codigo_invalido'), function(){element.focus();});
                            return false;
                        }

                        Server.send({
                            'action': packet.PAGAR_CODIGO,
                            'ticket': ticket,
                            'codigo': codigo
                        });
                    }
                },
                cancel: function () {
                    //close
                },
            },
            onContentReady: function () {
                // bind to events
                let jc = this;
                let element = jc.$content.find('.input-ticket');
                element.on('keypress', function (e) {
                    if (e.which == 13) {
                        e.preventDefault();
                        jc.$$formSubmit.trigger('click');
                    }
                });

                element.focus();
            }
        });
    }

    let pagarSuccess = function (data) {
        $.confirm({
            title: 'Ticket Ganador!',
            content: '<div class="form-group">' +
            '<table width="100%">' +
            '   <tbody>' +
            '       <tr>' +
            '           <td width="40%">Ticket No:</td>' +
            '           <td>'+data.ticket+'</td>' +
            '       </tr>' +
            '       <tr>' +
            '           <td>Código:</td>' +
            '           <td>'+data.codigo+'</td>' +
            '       </tr>' +
            '       <tr>' +
            '           <td>&nbsp;</td>' +
            '           <td>&nbsp;</td>' +
            '       </tr>' +
            '       <tr>' +
            '           <td>Premio:</td>' +
            '           <td>'+data.premio+'</td>' +
            '       </tr>' +
            '       <tr>' +
            '           <td>&nbsp;</td>' +
            '           <td>&nbsp;</td>' +
            '       </tr>' +
            '   </tbody>' +
            '</table>' +
            '</div>',
            buttons: {
                cancel: function () {
                    //close
                },
                ok: {
                    text: 'Imprimir',
                    btnClass: 'btn-blue',
                    action: function () {
                        if (data.success) {
                            new PrinterTicketPagar(data).print();
                        }
                        else {
                            new PrinterTicketPagado(data).print();
                        }

                        return false;
                    }
                }
            },
            onContentReady: function () {
                let jc = this;
                let element = jc.$content.find('.input-ticket');
                element.on('keypress', function (e) {
                    if (e.which == 13) {
                        e.preventDefault();
                        jc.$$formSubmit.trigger('click');
                    }
                });

                element.focus();
            }
        });
    }

    let ventaDefineCash3 = function () {
        let html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-menu">';
        html += '<li id="'+Jugadas.CASH3_STRAIGHT+'"><a href="#link">Cash3 Straight</a></li>';
        html += '<li id="'+Jugadas.CASH3_BOX+'"><a href="#link">Cash3 Box</a></li>';
        html += '</ul>';

        $.confirm({
            useBootstrap: false,
            backgroundDismiss: true,
            title: 'Seleccione el tipo de jugada',
            content: html,
            buttons: {
                buttonA: {
                    isHidden: true
                },
                buttonB: {
                    isHidden: true
                }
            },
            onContentReady: function () {
                let modal = this;

                $('ul#dialog-menu li').keynavigator({
                    activeClass: 'alert-info',
                    keys: {
                        enter: function($el) {
                            let op_selected = $el.attr('id');
                            modal.close();

                            if (op_selected === Jugadas.CASH3_STRAIGHT) {
                                VentaActivity.defineCash3(true);
                            }
                            else {
                                VentaActivity.defineCash3(false);
                            }
                        }
                    }
                });

                $('ul#dialog-menu li:eq(0)').click();
            }
        });
    }

    let ventaDefinePlay4 = function () {
        let html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-menu">';
        html += '<li id="'+Jugadas.PLAY4_STRAIGHT+'"><a href="#link">Play4 Straight</a></li>';
        html += '<li id="'+Jugadas.PLAY4_BOX+'"><a href="#link">Play4 Box</a></li>';
        html += '</ul>';

        $.confirm({
            useBootstrap: false,
            backgroundDismiss: true,
            title: 'Tipo de jugada',
            content: html,
            buttons: {
                buttonA: {isHidden: true},
                buttonB: {isHidden: true}
            },
            onContentReady: function () {
                let modal = this;

                $('ul#dialog-menu li').keynavigator({
                    activeClass: 'alert-info',
                    keys: {
                        enter: function($el) {
                            let op_selected = $el.attr('id');
                            modal.close();

                            if (op_selected === Jugadas.PLAY4_STRAIGHT) {
                                VentaActivity.definePlay4(true);
                            }
                            else {
                                VentaActivity.definePlay4(false);
                            }
                        }
                    }
                });

                $('ul#dialog-menu li:eq(0)').click();
            }
        });
    }

    let ventaDefinePale = function () {
        let html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-menu">';
        html += '<li id="'+Jugadas.PALE+'"><a href="#link">Palé</a></li>';
        html += '<li id="'+Jugadas.SUPER_PALE+'"><a href="#link">Super Palé</a></li>';
        html += '</ul>';

        $.confirm({
            useBootstrap: false,
            backgroundDismiss: true,
            title: 'Tipo de jugada',
            content: html,
            buttons: {
                buttonA: {isHidden: true},
                buttonB: {isHidden: true}
            },
            onContentReady: function () {
                let modal = this;

                $('ul#dialog-menu li').keynavigator({
                    activeClass: 'alert-info',
                    keys: {
                        enter: function($el) {
                            let op_selected = $el.attr('id');
                            modal.close();
                            if (op_selected == Jugadas.SUPER_PALE) {
                                VentaActivity.definePale(true);
                            }
                            else {
                                VentaActivity.definePale(false);
                            }
                        }
                    }
                });

                $('ul#dialog-menu li:eq(0)').click();
            }
        });
    }

    let ventaDefineMariage = function () {
        let html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-menu">';
        html += '<li id="'+Jugadas.MARIAGE+'"><a href="#link">Mariage</a></li>';
        html += '<li id="'+Jugadas.LOTO4+'"><a href="#link">Loto 4</a></li>';
        html += '</ul>';

        $.confirm({
            useBootstrap: false,
            backgroundDismiss: true,
            title: 'Tipo de jugada',
            content: html,
            buttons: {
                buttonA: {isHidden: true},
                buttonB: {isHidden: true}
            },
            onContentReady: function () {
                let modal = this;

                $('ul#dialog-menu li').keynavigator({
                    activeClass: 'alert-info',
                    keys: {
                        enter: function($el) {
                            let op_selected = $el.attr('id');
                            modal.close();
                            if (op_selected == Jugadas.MARIAGE) {
                                VentaActivity.defineMariage(true);
                            }
                            else {
                                VentaActivity.defineMariage(false);
                            }
                        }
                    }
                });

                $('ul#dialog-menu li:eq(0)').click();
            }
        });
    }

    let ventaDefineFromBack = function () {
        let html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-menu">';
        html += '<li id="'+Jugadas.FRONT_BACK3_F+'"><a href="#link">Pick3 Front</a></li>';
        html += '<li id="'+Jugadas.FRONT_BACK3_B+'"><a href="#link">Pick3 Back</a></li>';
        html += '<li id="'+Jugadas.FRONT_BACK4_F+'"><a href="#link">Pick4 Front</a></li>';
        html += '<li id="'+Jugadas.FRONT_BACK4_B+'"><a href="#link">Pick4 Back</a></li>';
        html += '</ul>';

        $.confirm({
            useBootstrap: false,
            backgroundDismiss: true,
            title: 'Tipo de jugada',
            content: html,
            buttons: {
                buttonA: {isHidden: true},
                buttonB: {isHidden: true}
            },
            onContentReady: function () {
                let modal = this;

                $('ul#dialog-menu li').keynavigator({
                    activeClass: 'alert-info',
                    keys: {
                        enter: function($el) {
                            let op_selected = $el.attr('id');
                            modal.close();

                            VentaActivity.defineFromBack(op_selected);
                        }
                    }
                });

                $('ul#dialog-menu li:eq(0)').click();
            }
        });
    }

    return {
        configMenu: configMenu,
        pagar: pagar,
        pagarCodigo: pagarCodigo,
        pagarSuccess: pagarSuccess,
        ventaDefinePale: ventaDefinePale,
        ventaDefineMariage: ventaDefineMariage,
        ventaDefineFromBack: ventaDefineFromBack,
        ventaDefineCash3: ventaDefineCash3,
        ventaDefinePlay4: ventaDefinePlay4,
    }
}();