"use strict";

let filter = {

    // devuelve un string
    number: function (str) {
        str = str+"";

        if (!str || str.length < 1) { return ""; }

        str = str.trim();
        if (str.length < 1) { return ""; }

        return str.replace(/\D/g,'');
    },

    // devuelve un entero
    int: function (str) {
        if (typeof str === 'undefined') {
            return 0;
        }

        let n = parseInt(str);

        if (isNaN(n)) {
            return 0;
        }

        return n;
    },

    // devuelve un decimal
    float: function (str) {
        let n = parseFloat(str);

        if (isNaN(n)) {
            return 0;
        }

        return n;
    },

    alphanum: function (str) {
        if (!str) { return ""; }
        return str.replace(/[^0-9a-zA-Z]/gi, '');
    },

    alphanumdash: function (str) {
        if (!str) { return ""; }
        return str.replace(/[^0-9a-zA-Z-_]/gi, '');
    },

    alphanumall: function (str) {
        if (!str) { return ""; }
        return str.replace(/[^0-9a-zA-ZÀ-ÿ\s]/gi, '');
    },

    dotnum: function (str) {
        if (!str) { return ""; }
        return str.replace(/[^0-9.]/gi, '');
    },

    html: function (str) {
        return str.replace(/<(?:.|\n)*?>/gm, '');
    },

    noSpace: function (str) {
        return str.replace(/\s/g,'');
    },

    len: function (str,len) {
        return str.substr(0,len);
    },

    phone: function (str) {
        if (!str) { return ""; }
        return str.replace(/[^0-9-()\s]/gi, '');
    },
}