"use strict";

const low = require('lowdb')
const FileSync = require('lowdb/adapters/FileSync')
const System = require('./../main/System');

let DB = function () {
    const adapter = new FileSync(System.getDbFolder() + '/db.json');
    const db = low(adapter);

    let init = function () {
        db.defaults({ chats: [], contacts: [], tickets: [] }).write();
    }

    let getDB = function() {
        return db;
    }

    let has = function (key) {
        return db.has(key).value();
    }

    let set = function (key, value) {
        db.set(key, value).write();
    }

    let get = function (key, def) { console.log("DB.get():"+key + " def:"+def);
        console.log("has():" + db.has(key).value());
        console.log("value: " + db.get(key).value());

        if (db.has(key).value()) {
            return db.get(key).value();
        }
        else {
            return def;
        }
    }

    let remove = function (key) {
        db.get(key).remove().write();
    }

    return {
        init: init,
        getDB: getDB,
        has: has,
        set: set,
        get: get,
        remove: remove,

        SERVER_IP: "server_ip",
        SERVER_PORT: "server_port",
        SERVER_URL_UPDATE: "server_url_update",
        SERVER_URL_UPDATE_CHECK: "server_url_update_check",

        PRINTER: "printer",

        EMPRESA_ID: "empresa_id",
        EMPRESA_NOMBRE: "empresa_nombre",
        EMPRESA_ESZONA: "empresa_eszona",
        LAUNCHER: "launcher",

        CONTACTS_TICKET_NONE: "contacts_ticket_none",
        CONTACTS_TICKET_NONE_SELECTED: "contacts_ticket_none_selected",
        CONTACTS_TICKET_SMS: "contacts_ticket_sms",
        CONTACTS_TICKET_SMS_SELECTED: "contacts_ticket_sms_selected",
        CONTACTS_TICKET_WHATSAPP: "contacts_ticket_whatsapp",
        CONTACTS_TICKET_WHATSAPP_SELECTED: "contacts_ticket_whatsapp_selected",

        AVATAR: "avatar",
        THEME_BG: "profile_bg",
        THEME: "theme",
        PASSWORD: "password",
        USERNAME: "username",
        MESSAGES: "messages",
        CONFIG_TICKET_COMBINAR: "config_ticket_combinar",
        CONFIG_TICKET_DETECTAR_ORIGEN: "config_ticket_detectar_origen",
        CONFIG_TICKET_DETECTAR_DUPLICADOS: "config_ticket_detectar_duplicados",
        CONFIG_JUGADA_SELECCION_LOTERIA: "config_jugada_seleccion_loteria",

    }

}();

module.exports = DB;