let Tickets = function() {
    "use strict";

    let list = [];

    let init = function (rows) {
        list = [];

        rows.forEach(function (row) {
            list.push(new Ticket(row.id, row.type, row.ticket, row.codigo, row.fecha, row.monto, row.estatus, row.contacto, row.premio));
        });
    }

    let get = function(position) {
        return list[position];
    }

    let getFromID = function(id) {
        list.forEach(function (ticket) {
            if (ticket.getId() == id) {
                return ticket;
            }
        })
    }

    let getAll = function () {
        return list;
    }

    let countGanadores = function () {
        let total = 0;
        list.forEach(function (ticket) {
            if (ticket.isPremiado()) {
                total++;
            }
        });

        return total;
    }

    return {
        init: init,
        get: get,
        getFromID: getFromID,
        getAll: getAll,
        countGanadores: countGanadores
    }
}();