let TicketCopiar = function () {

    let ticket_id = 0;

    let copiar = function () {
        $.confirm({
            escapeKey: true,
            backgroundDismiss: true,
            title: _t('ticket_modal_copiar'),
            content: '<div class="form-group"><input type="text" placeholder="'+_t('ticket_modal_copiar_hint')+'" class="input-ticket form-control"/></div>',
            buttons: {
                formSubmit: {
                    text: _t('accept'),
                    btnClass: 'btn-blue',
                    action: function () {
                        let jc = this;
                        let element = jc.$content.find('.input-ticket');
                        ticket_id = element.val();
                        if (ticket_id.length < 8) {
                            ui.dialogErrorSimple(_t('ticket_invalido'), function(){
                                element.focus();
                            });
                            return false;
                        }

                        copiarPreguntar();
                    }
                },
                cancel: function () {},
            },
            onContentReady: function () {
                // bind to events
                let jc = this;
                let element = jc.$content.find('.input-ticket');
                element.on('keypress', function (e) {
                    if (e.which == 13) {
                        e.preventDefault();
                        jc.$$formSubmit.trigger('click');
                    }
                });

                element.focus();
            }
        });
    }

    let copiarPreguntar = function () {
        let html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-preguntar">';
        html += '<li id="copiar"><a href="#link">'+ _t('copy') +'</a></li>';
        html += '<li id="cambiar"><a href="#link">'+ _t('ticket_copiar_cambiar_loteria') +'</a></li>';
        html += '</ul>';

        $.dialog({
            escapeKey: true,
            backgroundDismiss: true,
            title: '',
            closeIcon: false,
            content: html,
            onContentReady: function () {
                let modal = this;

                $('ul#dialog-preguntar li').keynavigator({
                    activeClass: 'alert-info',
                    keys: {
                        enter: function($el) {
                            let op_selected = $el.attr('id');
                            modal.close();

                            if (op_selected == 'copiar') {
                                Server.send({
                                    'action': packet.COPIAR,
                                    'ticket': ticket_id
                                });
                            }
                            else if (op_selected == 'cambiar') {
                                copiarLoterias();
                            }
                        }
                    }
                });

                $('ul#dialog-preguntar li:eq(0)').click();
            }
        });
    }

    let copiarLoterias = function () {
        let html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-menu">';
        const loterias = Loterias.getList();
        loterias.forEach(function (loteria) {
            if (!loteria.isOpen()) { return; }
            html += '<li id="'+loteria.getId()+'">' +
                '<div class="checkbox"><input type="checkbox" id="check-'+loteria.getId()+'">' +
                '<label for="check-'+loteria.getId()+'"><a href="#link">'+loteria.getNombre()+'</a></label>' +
                '</div></li>';
        });
        html += '</ul>';

        $.confirm({
            escapeKey: true,
            backgroundDismiss: true,
            useBootstrap: false,
            title: '',
            content: html,
            buttons: {
                buttonA: {isHidden: true},
                buttonB: {isHidden: true}
            },
            onContentReady: function () {
                let modal = this;

                $('ul#dialog-menu li').keynavigator({
                    activeClass: 'alert-info',
                    keys: {
                        enter: function($el) {
                            modal.close();

                            let loterias_selected = [];
                            let elements = $el.parent().find(':checkbox');
                            Object.values(elements).forEach(function(element) {
                                element = $(element);
                                if (element.prop('checked')) {
                                    loterias_selected.push(filter.number(element.attr('id')));
                                }
                            });
                            loterias_selected = loterias_selected.unique();

                            Server.send({
                                'action': packet.COPIAR,
                                'ticket': ticket_id,
                                'loterias': loterias_selected.join(',')
                            });
                        },
                        107: function($el) {
                            $el.find(':checkbox').prop('checked', !$el.find(':checkbox').prop('checked'));
                        }
                    }
                });

                $('ul#dialog-menu li:eq(0)').click();
            }
        });
    }

    return {
        copiar: copiar,
        copiarPreguntar: copiarPreguntar,
        activeTicket: function(tid) {
            ticket_id = tid;
        }
    }
}();

