let TicketAnular = function () {

    let anular = function () {
        $.confirm({
            escapeKey: true,
            backgroundDismiss: true,
            title: _t('ticket_modal_anular'),
            content: '<div class="form-group"><input type="text" placeholder="Ticket No." class="input-ticket form-control"/></div>',
            buttons: {
                formSubmit: {
                    text: _t('accept'),
                    btnClass: 'btn-blue',
                    action: function () {
                        let jc = this;
                        let element = jc.$content.find('.input-ticket');
                        let ticket = element.val();
                        /*if (!ticket) {
                            jc.close();
                            return false;
                        }*/

                        if (ticket.length < 8) {
                            ui.dialogErrorSimple(_t('ticket_invalido'), function(){element.focus();});
                            return false;
                        }

                        Server.send({
                            'action': packet.ANULAR,
                            'ticket': ticket
                        });
                    }
                },
                cancel: function () {
                    //close
                },
            },
            onContentReady: function () {
                // bind to events
                let jc = this;
                let element = jc.$content.find('.input-ticket');
                element.on('keypress', function (e) {
                    if (e.which == 13) {
                        e.preventDefault();
                        jc.$$formSubmit.trigger('click');
                    }
                });

                element.focus();
            }
        });
    }

    let anularCodigo = function (ticket) {
        $.confirm({
            title: _t('ticket_modal_anular'),
            content: '<div class="form-group"><input type="text" placeholder="Código" class="input-ticket form-control"/></div>',
            buttons: {
                formSubmit: {
                    text: _t('accept'),
                    btnClass: 'btn-blue',
                    action: function () {
                        let jc = this;
                        let element = jc.$content.find('.input-ticket');
                        let codigo = element.val();
                        /*if (!codigo) {
                            jc.close();
                            return false;
                        }*/

                        if (codigo.length != 4) {
                            ui.dialogErrorSimple(_t('ticket_codigo_invalido'), function(){element.focus();});
                            return false;
                        }

                        Server.send({
                            'action': packet.ANULAR_CODIGO,
                            'ticket': ticket,
                            'codigo': codigo
                        });
                    }
                },
                cancel: function () {
                    //close
                },
            },
            onContentReady: function () {
                // bind to events
                let jc = this;
                let element = jc.$content.find('.input-ticket');
                element.on('keypress', function (e) {
                    if (e.which == 13) {
                        e.preventDefault();
                        jc.$$formSubmit.trigger('click');
                    }
                });

                element.focus();
            }
        });
    }

    return {
        anular: anular,
        anularCodigo: anularCodigo,
    }
}();

