"use strict";

function Ticket(id, type, ticket, codigo, fecha, monto, estatus, contacto, premio) {
    this.id = id;
    this.type = type;
    this.ticket = ticket;
    this.codigo = codigo;
    this.fecha = fecha;
    this.monto = monto;
    this.estatus = estatus;
    this.contacto = contacto;
    this.premio = premio;
}

Ticket.prototype.getId = function() {
    return this.id;
}

Ticket.prototype.getType = function() {
    return this.type;
}

Ticket.prototype.getTicket = function() {
    return this.ticket;
}

Ticket.prototype.getFecha = function () {
    return Time.dateToFecha(this.fecha, "DD/MM/YYYY HH:mm a").toLowerCase();
}

Ticket.prototype.getHora = function () {
    return Time.dateToFecha(this.fecha, "h:mm a").toLowerCase();
}

Ticket.prototype.getMonto = function() {
    let monto = this.monto.replace(',','');
    return parseInt(monto).formatMoney(0)
}

Ticket.prototype.getEstatus = function() {
    return this.estatus;
}

Ticket.prototype.getPremio = function() {
    return this.premio;
}

Ticket.prototype.getContacto = function() {
    return this.contacto;
}

Ticket.prototype.isPremiado = function() {
    return this.estatus === "Ganador";
}
