let Vendedor = function () {

    let id;
    let nombre;
    let telefono;

    let recargas_enabled = 0;
    let ticket_config_impresora = 0;
    let ticket_config_sms = 0;
    let ticket_config_none = 0;


    let init = function() { console.log("Vendedor.init()");

        $('div').on('click', '#venta-icon-print>button', function (e) { console.log("print");
            e.stopPropagation();
            VentaActivity.send();
        });

        /*$('div').on('click', '#venta-icon-sms>button', function (e) { console.log("sms");
            e.stopPropagation();
            VentaActivity.sendSMS();

        });

        $('div').on('click', '#venta-icon-none>button', function (e) { console.log("none");
            e.stopPropagation();
            VentaActivity.sendNone();
        });*/

    }

    let touch = function(data) { console.log("Vendedor.touch()"); console.log(data);

        id = data["id"]?data["id"]:id;
        nombre = data["nombre"];
        telefono = data["phone"];

        $('#vendedor').text('Vendedor: ' + nombre);

        updateTicketConfig(data);


        recargas_enabled = parseInt(data['recargas_enabled']);
        if (recargas_enabled === 1) {
            $('#menu_td_recargas').show();
        }
        else {
            $('#menu_td_recargas').hide();
        }

        /*// si esta activa la pantalla de ventas, se actualizan los iconos del Actionbar
        if (App.isActivePage(Co.PAGE_VENDER)) {
            VentaActivity.setOptionsIcons();
        }*/
    }

    let touchTerminal = function(data) { console.log("Vendedor.touchTerminal()");

        let printer_tipo = data["printer_tipo"];
        if (printer_tipo) {
            Empresa.setPrinterTipo(printer_tipo);
        }
    }

    let updateTicketConfig = function(data) {

        if (data["ticket_config"]) {
            let tconfig = data["ticket_config"];
            ticket_config_impresora = tconfig["printer"];
            ticket_config_sms = tconfig["sms"];
            ticket_config_none = tconfig["none"];
        }
        else {
            ticket_config_impresora = 0;
            ticket_config_sms = 0;
            ticket_config_none = 0;
        }
    }

    return {
        init: init,
        touch: touch,
        touchTerminal: touchTerminal,

        getId: function() {
            return id;
        },

        getNombre: function() {
            return nombre;
        },

        getTheme: function() {
            return Theme.getTheme();
        },

        hasTicketSendImpresora: function() {
            return ticket_config_impresora === 1;
        },

        hasTicketSendSMS: function() {
            return ticket_config_sms === 1;
        },

        hasTicketSendNone: function() {
            return ticket_config_none === 1;
        },

        isTicketSendConfigured: function() {
            return (ticket_config_impresora + ticket_config_sms + ticket_config_none) > 0;
        }
    }
}();