let Theme = function () {
    let themes = {
        'FFFFFF': 'a',
        '212B30': 'b',
        '263543': 'c',
        '22222F': 'd',
        '4688F2': 'e',
        '9C27B0': 'f',
        '673AB7': 'g',
        '3F51B5': 'h',
        '009688': 'i',
        'FF9800': 'j',
        'FF5722': 'k',
        '607D8B': 'l',
        '212121': 'm',
        '2980B9': 'n',
        '9F4320': 'o',
        '3C6013': 'p',
        '50801A': 'q',
        '136047': 'r',
        '1A8073': 'u',
        '1A6A80': 'w',

        '134260': 'x1',
        '1A5780': 'x2',
        '206D9F': 'x3',
        '2683BF': 'x4',
        '132D60': 'x5',
        '1A3B80': 'x6',
        '204A9F': 'x7',
        '2659BF': 'x8',
        '2B26BF': 'x9',
        '322DDF': 'x10'
    }

    let changeTheme = function (color) {
        color = color.replace('#', '');
        let theme = themes[color];
        if (theme) {
            DB.set(DB.THEME, theme);
            apply();
        }
    }

    let apply = function () {
        let theme = DB.get(DB.THEME);
        if (!theme) {
            theme = 'a';
        }

        for (let key in themes) {
            $(".site-header").removeClass('theme-' + themes[key]);
            $("#tb_top_menu").removeClass('theme-' + themes[key] + '-menu');
        }

        $(".site-header").addClass('theme-' + theme);
        $("#tb_top_menu").addClass('theme-' + theme + '-menu');
    }

    let getTheme = function () {
        let theme = DB.get(DB.THEME);
        if (!theme) {
            theme = 'a';
        }

        return theme;
    }

    return {
        apply: apply,
        getTheme: getTheme,
        changeTheme: changeTheme
    }
}();
//9F4320
//3C6013|50801A
//136047|1A805F
//136056|1A8073
//135060|1A6A80

//134260|1A5780
//206D9F|2683BF
//132D60|1A3B80
//204A9F|2659BF
//2B26BF|322DDF