let PrinterTicketPagar = function (data) {
    "use strict";

    this.fecha = data["fecha"];
    this.ticket_numero = data["ticket"];
    this.ticket_codigo = data["codigo"];
    this.ticket_barcode = data["barcode"];
    this.premio = data["premio"];
}

PrinterTicketPagar.prototype.print = function() {
    Printer.reset();

    this.header();
    this.labelTipoGanador();
    this.montoPremio();
    this.firmaCliente();

    Printer.print();
}

PrinterTicketPagar.prototype.header = function() {
    Printer.fontA();
    Printer.center();

    Printer.emphasized();
    Printer.underline();
    Printer.line(Empresa.getNombre());
    Printer.underlineOff();
    Printer.emphasizedOff();

    Printer.line(Empresa.getEslogan());

    Printer.left();
    Printer.line("Tel: " + Empresa.getTelefono());
    Printer.line("Vendedor: " + Vendedor.getNombre());
    Printer.line("Fecha: " + this.fecha);
    Printer.br();

    Printer.line("Ticket No: " + this.ticket_numero + " - Cod: " + this.ticket_codigo);
    Printer.br(2);
}

PrinterTicketPagar.prototype.labelTipoGanador = function() {
    Printer.fontA();
    Printer.center();
    Printer.line("TICKET GANADOR!");
    Printer.br();
}

PrinterTicketPagar.prototype.montoPremio = function() {
    Printer.fontA();
    Printer.center();
    Printer.line("Monto: $" + this.premio);
    Printer.br(3);
}

PrinterTicketPagar.prototype.firmaCliente = function() {
    Printer.fontA();
    Printer.center();
    Printer.line("----------------------");
    Printer.line("Firma comprobante");
    Printer.line("\n");
    Printer.br();
    Printer.br();
    Printer.br();
}