let PrinterTicketPagado = function (data) {
    "use strict";

    this.fecha = data["fecha"];
    this.ticket_numero = data["ticket"];
    this.ticket_codigo = data["codigo"];
    this.ticket_barcode = data["barcode"];
    this.premio = data["premio"];
}

PrinterTicketPagado.prototype.print = function() {
    Printer.reset();

    this.header();
    Printer.br();

    this.labelTipoGanador();
    Printer.br();

    this.montoPremio();
    Printer.br(3);
    Printer.br();

    Printer.print();
}

PrinterTicketPagado.prototype.header = function() {
    Printer.fontA();
    Printer.center();

    Printer.emphasized();
    Printer.underline();
    Printer.line(Empresa.getNombre());
    Printer.underlineOff();
    Printer.emphasizedOff();

    Printer.line(Empresa.getEslogan());

    Printer.left();
    Printer.line("Tel: " + Empresa.getTelefono());
    Printer.line("Vendedor: " + Vendedor.getNombre());
    Printer.line("Fecha: " + this.fecha);
    Printer.br();

    Printer.line("Ticket No: " + this.ticket_numero + " - Cod: " + this.ticket_codigo);
    Printer.br();
}

PrinterTicketPagado.prototype.labelTipoGanador = function() {
    Printer.fontA();
    Printer.center();
    Printer.line("TICKET GANADOR!");
    Printer.line("YA HA SIDO PAGADO");
}

PrinterTicketPagado.prototype.montoPremio = function() {
    Printer.fontA();
    Printer.center();
    Printer.line("Monto: $" + this.premio);
}