let PrinterTicket = function (data) {
    "use strict";


    this.fecha = data["fecha"];
    this.ticket_numero = data["ticket"];
    this.ticket_codigo = data["codigo"];
    this.ticket_barcode = data["barcode"];

    this.total_jugadas = 0;
    this.total_valor = 0;

    this.loterias_head = {};

    let self = this;
    let loteria;
    data.jugadas.forEach(function(jugada) {
        jugada = new Jugada(jugada.numero, jugada.loteria, jugada.valor, jugada.jugstr);
        jugada.getLoterias().forEach(function (loteria_id) {
            loteria = Loterias.get(loteria_id);
            console.log(loteria_id);
            console.log(loteria);
            self.loterias_head[loteria.getAbreviado()] = loteria.getAbreviado() + " -> " + loteria.getNombre();
        });

        self.total_valor += jugada.getValor2();
        self.total_jugadas++;
    });
}

PrinterTicket.prototype.print = function() {
    Printer.reset();

    this.header();

    this.labelLoterias();
    Printer.br();

    this.jugadasHeader();
    this.jugadas();

    this.footer();
    Printer.br(2);

    this.pie();
    Printer.br();

    Printer.qrcode(this.ticket_barcode, 51, 5, 48);
    Printer.br(5);

    Printer.print();
}

PrinterTicket.prototype.header = function() {

    Printer.fontA();
    Printer.center();

    Printer.emphasized();
    Printer.underline();
    Printer.line(Empresa.getNombre());
    Printer.underlineOff();
    Printer.emphasizedOff();

    Printer.line(Empresa.getEslogan());
    Printer.br();

    Printer.left();

    if (Empresa.getUseVenTel() < 2) {
        Printer.line("Tel: " + Empresa.getTelefono());
    }

    if (Empresa.showVendedorInTicket()) {
        Printer.line("Vendedor: " + Vendedor.getNombre());
    }

    Printer.line("Fecha: " + this.fecha);
    Printer.br();

    Printer.line("Ticket No:" + this.ticket_numero + " - Cod:" + this.ticket_codigo);
    Printer.br();

    Printer.center();
    Printer.line("VENTA DE LOTERIA");
}

PrinterTicket.prototype.labelLoterias = function() { console.log("PrinterTicket.labelLoterias()");
    Printer.fontA();
    Printer.left();

    let self = this;
    Object.keys(this.loterias_head).forEach(function (key) {
        Printer.line(self.loterias_head[key]);
    });
}

PrinterTicket.prototype.jugadasHeader = function() { console.log("PrinterTicket.jugadasHeader()");
    Printer.fontA();
    Printer.left();

    if (Co.PRINTER_TYPE_80MM == Empresa.getPrinterTipo()) {
        Printer.write("PR".padEnd(7));
        Printer.write("Numeros".padEnd(15));
        Printer.write("Loterias".padEnd(16));
        Printer.write("Valor".padStart(10));
        Printer.br();
        Printer.line("------------------------------------------------");
    }
    else {
        Printer.write("PR".padEnd(4));
        Printer.write("Numeros".padEnd(10));
        Printer.write("Loterias".padEnd(10));
        Printer.write("Valor".padStart(8));
        Printer.br();
        Printer.line("--------------------------------");
    }
}

PrinterTicket.prototype.jugadas = function() { console.log("PrinterTicket.jugadas()");
    Printer.fontA();
    Printer.left();

    let jugada;
    for (let i=0; i<Jugadas.size(); i++) {
        jugada = Jugadas.get(i);

        Printer.emphasized();
        if (Co.PRINTER_TYPE_80MM == Empresa.getPrinterTipo()) {
            Printer.write(jugada.getJugstr().padEnd(7));
            Printer.write(jugada.getNumero2().padEnd(15));
            Printer.write(jugada.getLoteriasAbreviado().padEnd(16));
            Printer.write(("$" + jugada.getValor2()).padStart(10));
        }
        else {
            Printer.write(jugada.getJugstr().padEnd(4));
            Printer.write(jugada.getNumero2().padEnd(10));
            Printer.write(jugada.getLoteriasAbreviado().padEnd(10));
            Printer.write(("$" + jugada.getValor2()).padStart(8));
        }

        Printer.emphasizedOff();
        Printer.br();
    }
}

PrinterTicket.prototype.footer = function() { console.log("PrinterTicket.footer()"); console.log(Empresa.getPrinterTipo());
    Printer.left();
    Printer.fontA();

    let total_jugadas_str = this.total_jugadas.toString();
    let total_valor_str = this.total_valor.toString();

    if (Co.PRINTER_TYPE_80MM == Empresa.getPrinterTipo()) {
        Printer.line("------------------------------------------------");

        Printer.emphasized();
        Printer.write("Total:".padEnd(22));
        Printer.write(('000'+total_jugadas_str).substring(total_jugadas_str.length).padEnd(16));
        Printer.write(("$" + total_valor_str).padStart(10));
        Printer.emphasizedOff();

        Printer.br();
    }
    else {
        Printer.line("--------------------------------");

        Printer.emphasized();
        Printer.write("Total:".padEnd(14));
        Printer.write(('000'+total_jugadas_str).substring(total_jugadas_str.length).padEnd(8));
        Printer.write(("$" + total_valor_str).padStart(10));
        Printer.emphasizedOff();

        Printer.br();
    }
}

PrinterTicket.prototype.pie = function() {
    Printer.fontA();
    Printer.center();

    if (Empresa.getTicketPie1()) {
        Printer.line(Empresa.getTicketPie1());
    }

    if (Empresa.getTicketPie2()) {
        Printer.line(Empresa.getTicketPie2());
    }

    if (Empresa.getTicketPie3()) {
        Printer.line(Empresa.getTicketPie3());
    }
}

