let PrinterReporte = function (data) {
    "use strict";
    this.data = data;
}

PrinterReporte.prototype.print = function() {
    Printer.reset();

    Printer.fontA();
    Printer.center();

    Printer.emphasized();
    Printer.underline();
    Printer.line(Empresa.getNombre());
    Printer.underlineOff();
    Printer.emphasizedOff();

    Printer.line("Fecha: " + this.data.fecha);
    Printer.line("Vendedor: " + Vendedor.getNombre());
    Printer.br();
    Printer.line("--------------------------------");
    Printer.br();

    Printer.underline();
    Printer.line("Resumen de Ventas");
    Printer.underlineOff();

    if (this.data.has_recargas) {
        Printer.boldOff();

        Printer.write("Recargas:".padEnd(20)).write(this.data.recargas.toString().padStart(10)).br();
        Printer.write("Ventas:".padEnd(20)).write(this.data.ventas.padStart(10)).br();
        Printer.write("Premios:".padEnd(20)).write(this.data.premios.padStart(10)).br();
        Printer.write("Comision Ventas:".padEnd(20)).write(this.data.comision.padStart(10)).br();
        Printer.write("Comision Recargas:".padEnd(20)).write(this.data.recargas_comision.toString().padStart(10)).br();
    }
    else {
        Printer.write("Ventas:".padEnd(20)).write(this.data.ventas.padStart(10)).br();
        Printer.write("Comision:".padEnd(20)).write(this.data.comision.padStart(10)).br();
        Printer.write("Premios:".padEnd(20)).write(this.data.premios.padStart(10)).br();
    }

    Printer.bold();
    Printer.write("Resultado:".padEnd(20)).write(this.data.resultado.padStart(10)).br();
    Printer.boldOff();


    Printer.br(5);

    Printer.print();
}