let Jugadas = function() {

    let jugadas = [];

    let reset = function() {
        jugadas = [];
    }

    let add = function(jugada) {
        jugadas.push(jugada);
    }

    let remove = function(position) {
        jugadas.splice(position, 1);
    }

    let get = function(position) {
        return jugadas[position];
    }

    let getAll = function () {
        return jugadas;
    }

    let size = function() {
        return jugadas.length;
    }

    let totalMonto = function() {
        let total = 0;
        for (let i=0; i<jugadas.length; i++) {
            total += jugadas[i].getValor2();
        }
        return total;
    }

    //----------------------------------------------------------------------------------------------
    let existe = function(j) {

        let result = null;

        for (let i=0; i<jugadas.length; i++) {
            let jugada = jugadas[i];

            if  (jugada.getLoteria() == j.getLoteria()) {
                if (jugada.getNumero() == j.getNumero()) {
                    if (jugada.getJugstr() == j.getJugstr()) {
                        result = jugada;
                        break;
                    }
                }
            }
        }

        return result;
    }

    return {
        reset: reset,
        add: add,
        remove: remove,
        get: get,
        getAll: getAll,
        size: size,
        totalMonto: totalMonto,
        existe: existe,

        QUINIELA: "QN",
        PALE: "PL",
        SUPER_PALE: "SP",
        TRIPLETA: "TR",
        CASH3_STRAIGHT: "CS",
        CASH3_BOX: "CB",
        PLAY4_STRAIGHT: "PS",
        PLAY4_BOX: "PB",
        BORLETTE: "BO",
        MARIAGE: "MA",
        LOTO3: "L3",
        LOTO4: "L4",
        LOTO5: "L5",
        LOTO6: "L6",
        FRONT_BACK3_F: "3F",
        FRONT_BACK3_B: "3B",
        FRONT_BACK4_F: "4F",
        FRONT_BACK4_B: "4B",
    }
}();