let Empresa = function () {
    "use strict";

    let id;
    let nombre;
    let eslogan;
    let telefono;
    let direccion;

    let printer;
    let printer_type;

    let ticket_pie1;
    let ticket_pie2;
    let ticket_pie3;

    let app_version;
    let es_zona;
    let use_ventel;

    let ticket_show_vendedor;
    let ticket_config_impresora;
    let ticket_config_sms;
    let ticket_config_none;

    let update;
    let url_update;
    let url_update_check;

    let init = function(data) { console.log("Empresa.init()");

        data = data["data"];

        id = data["id"];
        nombre = data["empresa"];
        eslogan = data["eslogan"];
        telefono = data["telefono"];
        direccion = data["direccion"];
        app_version = data["app_version_name"];

        printer = data["printer"];
        printer_type = data["printer_tipo"];

        ticket_pie1 = data["ticket_pie1"];
        ticket_pie2 = data["ticket_pie2"];
        ticket_pie3 = data["ticket_pie3"];
        ticket_show_vendedor = data["ticket_show_vendedor"];

        update = parseInt(data["update"]);
        es_zona = parseInt(data["es_zona"]);
        use_ventel = parseInt(data["use_ventel"]);

        url_update = data["url_update"];
        url_update_check = data["url_update_check"];

        updateTicketConfig(data);
        updateSesion();

        Time.setTimeZone(data.timezone);
    }

    let touch = function(data) { console.log("Empresa.touch()");

        data = data["data"];

        nombre = data["empresa"];
        eslogan = data["eslogan"];
        telefono = data["telefono"];
        direccion = data["direccion"];

        ticket_pie1 = data["ticket_pie1"];
        ticket_pie2 = data["ticket_pie2"];
        ticket_pie3 = data["ticket_pie3"];
        ticket_show_vendedor = data["ticket_show_vendedor"];

        update = parseInt(data["update"]);
        es_zona = parseInt(data["es_zona"]);
        use_ventel = parseInt(data["use_ventel"]);

        updateTicketConfig(data);
        updateSesion();

        //App.checkUpdate();
    }

    let updateSesion = function() {
        DB.set(DB.EMPRESA_ID, id);
        DB.set(DB.EMPRESA_NOMBRE, nombre);
        DB.set(DB.EMPRESA_ESZONA, es_zona);
        DB.set(DB.SERVER_URL_UPDATE, url_update);
        DB.set(DB.SERVER_URL_UPDATE_CHECK, url_update_check);
    }

    let updateTicketConfig = function(data) {
        if (data["ticket_config"]) {
            let tconfig = data["ticket_config"];
            ticket_config_impresora = parseInt(tconfig["printer"]);
            ticket_config_sms = parseInt(tconfig["sms"]);
            ticket_config_none = parseInt(tconfig["none"]);
        }
        else {
            ticket_config_impresora = 0;
            ticket_config_sms = 0;
            ticket_config_none = 0;
        }
    }

    let registerDeviceResult = function (data) {
        if (data.success) {
            ui.dialogSuccess(data.msg);
            DB.set(DB.EMPRESA_ID, data.empresa_id);
        }
        else {
            ui.dialogErrorSimple(data.msg);
        }
    }

    return {
        init: init,
        touch: touch,
        registerDeviceResult: registerDeviceResult,
        getId: function() {
            if (id == null) {
                return "";
            }

            return id;
        },
        getNombre: function() {
            return nombre;
        },

        getEslogan: function() {
            return eslogan;
        },

        getTelefono: function() {
            return telefono;
        },

        getPrinterTipo: function() {
            return printer_type;
        },

        getUseVenTel: function() {
            return use_ventel;
        },

        useVenTel: function() {
            return use_ventel == 1;
        },

        getTicketPie1: function() {
            return ticket_pie1;
        },

        getTicketPie2: function() {
            return ticket_pie2;
        },

        getTicketPie3: function() {
            return ticket_pie3;
        },

        hasId: function() {
            return id != null;
        },

        canUpdate: function() {
            return update == 1;
        },

        setPrinterTipo: function(tipo) {
            printer_type = tipo;
        },

        hasUpdate: function() {
            if (this.canUpdate()) {
                return App.getVersionName() != app_version;
            }

            return false;
        },

        esZona: function() {
            return es_zona == 1;
        },

        hasTicketSendImpresora: function() {
            let res = false;

            if (Vendedor.isTicketSendConfigured()) {
                if (Vendedor.hasTicketSendImpresora()) {
                    res = true;
                }
            }
            else {
                res = (ticket_config_impresora == 1);
            }

            return res;
        },

        hasTicketSendSMS: function() {
            let res = false;

            if (Vendedor.isTicketSendConfigured()) {
                if (Vendedor.hasTicketSendSMS()) {
                    res = true;
                }
            }
            else {
                res = ticket_config_sms == 1;
            }

            return res;
        },

        hasTicketSendNone: function() {
            let res = false;

            if (Vendedor.isTicketSendConfigured()) {
                if (Vendedor.hasTicketSendNone()) {
                    res = true;
                }
            }
            else {
                res = ticket_config_none == 1;
            }

            return res;
        },

        countTicketOptions: function () {
            let options = 0;

            if (this.hasTicketSendImpresora()) {
                options++;
            }

            if (this.hasTicketSendSMS()) {
                options++;
            }

            if (this.hasTicketSendNone()) {
                options++;
            }

            return options;
        },

        showVendedorInTicket: function () {
            return parseInt(ticket_show_vendedor) === 1;
        },

        /**
         * Devuelve el ID de empresa guardado en sesion
         */
        getSesId: function() {
            return DB.get(DB.EMPRESA_ID);
        },

        /**
         * Devuelve el nombre de empresa guardado en sesion
         */
        getSesName: function() {
            return DB.get(DB.EMPRESA_NOMBRE);
        },

        /**
         * Devuelve el eszona de empresa guardado en sesion
         */
        getSesEsZona: function() {
            return DB.get(DB.EMPRESA_ESZONA);
        },

        /**
         * Checa el valor eszona guardado en sesion
         */
        isSesEsZona: function() {
            return DB.get(DB.EMPRESA_ESZONA);
        },
    }
}();
