let Message = function (id, sender_id, receiver_id, message, fecha, delivered, read, type) {

    this.id = id;
    this.sender_id = sender_id;
    this.receiver_id = receiver_id;
    this.message = message;
    this.fecha = fecha;
    this.delivered = delivered;
    this.read = read;
    this.type = type;

    this.checkFiles();
}

Message.prototype.checkFiles = function() {
    if (!this.isValid()) {
        return;
    }

    if (this.getType() === Co.MSG_RECEIVE_AUDIO || this.getType() === Co.MSG_SEND_AUDIO) {
        let filePath = App.getAudioPath(message);
        if (App.fileExist(filePath)) {
            ChatRoomMaster.downloadAudio(filePath, message, getFriendId());
        }
    }
    else if (this.getType() == Co.MSG_RECEIVE_IMAGE || this.getType() == Co.MSG_SEND_IMAGE) {
        let filePath = App.getImagePath(message);
        if (App.fileExist(filePath)) {
            ChatRoomMaster.downloadImage(filePath, message, getFriendId());
        }
    }
}

Message.prototype.isValid = function() {
    return parseInt(this.id) > 0;
}

Message.prototype.getId = function() {
    return this.id;
}

Message.prototype.getFriendId = function() {
    return this.isSelf() ? this.receiver_id : this.sender_id;
}

Message.prototype.getType = function() {
    let res;

    if (this.isSelf()) {
        switch (this.type) {
            case Co.MSG_TYPE_IMAGE:
                res = Co.MSG_SEND_IMAGE;
                break;
            case Co.MSG_TYPE_AUDIO:
                res = Co.MSG_SEND_AUDIO;
                break;
            default:
                res = Co.MSG_SEND_MESSAGE;
                break;
        }
    }
    else {
        switch (this.type) {
            case Co.MSG_TYPE_IMAGE:
                res = Co.MSG_RECEIVE_IMAGE;
                break;
            case Co.MSG_TYPE_AUDIO:
                res = Co.MSG_RECEIVE_AUDIO;
                break;
            default:
                res = Co.MSG_RECEIVE_MESSAGE;
                break;
        }
    }

    return res;
}

Message.prototype.getMessage = function() {
    if (this.getType() == Co.MSG_RECEIVE_AUDIO || this.getType() == Co.MSG_SEND_AUDIO) {
        let filePath = App.getAudioPath(this.message);
        if (App.fileExist(filePath)) {
            return "duration";
        }
        else {
            return "";
        }
    }
    else if (this.getType() == Co.MSG_RECEIVE_IMAGE || this.getType() == Co.MSG_SEND_IMAGE) {
        return "Imagen";
    }
    else {
        return this.message;
    }
}

Message.prototype.getImage = function() {
    let filePath = App.getImagePath(this.message);
    if (App.fileExist(filePath)) {
        return filePath;
    }

    return "";
}

Message.prototype.getAudio = function() {
    let filePath = App.getAudioPath(this.message);
    if (App.fileExist(filePath)) {
        return filePath;
    }

    return "";
}

Message.prototype.getDate = function() {
    return Time.formatChatTimeFecha(this.fecha);
}

Message.prototype.setDelivered = function() {
    this.delivered = 1;
}

Message.prototype.isDelivered = function() {
    return this.delivered == 1;
}

Message.prototype.setRead = function() {
    this.read = 1;
}

Message.prototype.isRead = function() {
    return this.read == 1;
}

Message.prototype.isSelf = function() { console.log("sender:"+this.sender_id+" userid:"+Vendedor.getId());
    return this.sender_id === Vendedor.getId();
}

Message.prototype.isNotSelf = function() {
    return !this.isSelf();
}