const NW = require('nw.gui');
const win = NW.Window.get();
const http = require("http");
const https = require("https");
const querystring = require('querystring');

let path = require("path");
let fs = require('fs');
let printer = require("printer");
let DB = require("./js/utils/db");
const StringUtils = require('string');
let validator = require('validator');
let _t = require('./js/lang/t');
let System = require('./js/main/System');
let SocClient = require('./js/server/SocClient');

//win.showDevTools();

global.window = {};

console.log(Server.getIp());
console.log(System.getAppDir());
console.log(process.execPath);

//System.downloadImage("http://2.bp.blogspot.com/-u7NKXrR0DqY/Tv6PYipHzCI/AAAAAAAAG-I/3YE3MWpmk4g/s1600/Derek+Jeter+Girlfriend+Hot+Minka+Kelly_6.jpg", "hot")
document.onkeydown = function (pressed) {
    //Check CTRL + F5 keys and hard refresh the page
    if ( pressed.ctrlKey === true && pressed.keyCode === 116 ) {
        pressed.preventDefault();
        win.reloadDev();
        return false;
        //Check Shift + F5 keys and refresh ignoring cache
    }
    else if ( pressed.shiftKey === true && pressed.keyCode === 116 ) {
        pressed.preventDefault();
        NW.App.clearCache()
        win.reloadIgnoringCache();
        return false;
        //Check F12 or Ctrl+Shift+I and display Webkit Dev Tools
    }
    else if ( pressed.keyCode === 123 || pressed.ctrlKey === true && pressed.shiftKey === true && pressed.keyCode === 73 ) {
        /*pressed.preventDefault();
        win.showDevTools();
        return false;*/
    }
};

let App = function () {
    let container_main = $('#container');
    let current_page;

    let initFsKeyboard = function () {
        $(document).keydown(function(event) { //console.log(event.which)
            if(event.which == 112) { console.log('F1');
                VentaActivity.init();
                /*$.notify({
                    icon: 'font-icon font-icon-warning',
                    title: '<strong>Heads up!</strong>',
                    message: 'You can use any of bootstraps other alert styles as well by default.'
                },{
                    type: 'error'
                });*/
                return false;
            }
            else if(event.which == 113) { console.log('F2');
                TicketCopiar.copiar();
                return false;
            }
            else if(event.which == 114) { console.log('F3');
                TicketAnular.anular();
                return false;
            }
            else if(event.which == 115) { console.log('F4');
                Modal.pagar();
                return false;
            }
            else if(event.which == 116) { console.log('F5');
                TicketCombinar.combinar();
                return false;
            }
            else if(event.which == 117) { console.log('F6');
                TicketsActivity.init();
                return false;
            }
            else if(event.which == 118) { console.log('F7');
                SorteosActivity.init();
                return false;
            }
            else if(event.which == 119) { console.log('F8');
                CuadreActivity.init();
                return false;
            }
            else if(event.which == 120) { console.log('F9');
                RecargasActivity.init();
                return false;
            }
            else if(event.which == 121) { console.log('F10');
                Modal.configMenu();
                return false;
            }
            else if(event.which == 122) { console.log('F11');
                ReporteActivity.init();
                return false;
            }
            else if(event.which == 123) { console.log('F12');
                if (App.isActivePage(Co.PAGE_VENDER)) {
                    VentaActivity.send();
                }
                else if (App.isActivePage(Co.PAGE_SORTEOS)) {
                    SorteosActivity.print();
                }
                else if (App.isActivePage(Co.PAGE_REPORTE_TICKETS)) {
                    TicketsActivity.print();
                }
                else if (App.isActivePage(Co.PAGE_CUADRE)) {
                    CuadreActivity.print();
                }

                return false;
            }
        });
    }
    
    let initDomListener = function () {
        $('#link_menu_vender').click(function () {
            VentaActivity.init();
        });

        $('#link_menu_copiar').click(function () {
            TicketCopiar.copiar();
        });

        $('#link_menu_anular').click(function () {
            TicketAnular.anular();
        });

        $('#link_menu_pagar').click(function () {
            Modal.pagar();
        });

        $('#link_menu_combinar').click(function () {
            TicketCombinar.combinar();
        });

        $('#link_menu_tickets').click(function () {
            TicketsActivity.init();
        });

        $('#link_menu_sorteos').click(function () {
            SorteosActivity.init();
        });

        $('#link_menu_cuadre').click(function () {
            CuadreActivity.init();
        });

        $('#link_menu_recargas').click(function () {
            RecargasActivity.init();
        });

        $('#link_menu_config').click(function () {
            Modal.configMenu();
        });

        $('#link_menu_reporte').click(function () {
            ReporteActivity.init();
        });

        $('#logout').click(function () {
            App.close();
            //Chat.close();
            //Server.close();
            //LoginActivity.init();
        });
    }

    let initThemePicker = function () {
        $(".colorPickSelector").colorPick({
            'paletteLabel': '',
            'allowRecent': false,
            'palette': ["#FFFFFF","#9F4320","#9C27B0","#673AB7","#607D8B","#3F51B5","#2980B9","#206D9F","#1A6A80","#136047","#1A8073","#2659BF","#134260","#1A5780","#263543","#212B30"],
            'onColorSelected': function() {
                Theme.changeTheme(this.color);
            }
        });
    }

    return {
        init: function () {
            container_main = $('#container');
            DB.init();
            Theme.apply();

            // conectar con el servidor
            Server.start();
            LoginActivity.init();
            Vendedor.init();

            initFsKeyboard();
            initDomListener();
            initThemePicker();

            // ininciar reloj
            let fecha = $("#fecha");
            let hora = $("#hora");
            setInterval(function() {
                fecha.text(moment().tz(App.getTimeZone()).format("DD/MM/YYYY"));
                hora.text(moment().tz(App.getTimeZone()).format("h:mm:ss A"));
            },1000);

            let resize_timer;
            win.on('resize',function() {
                clearTimeout(resize_timer);
                resize_timer = setTimeout(function() {

                    if (App.isActivePage(Co.PAGE_VENDER)) {
                        VentaActivity.checkOffset();
                    }

                }, 100);
            });

            $('#version').text('v' + Server.appVersion());
        },

        getContainerMain: function () {
            return container_main;
        },

        getTimeZone: function () {
            return Time.TIMEZONE;
        },

        setCurrentPage: function(page) {
            current_page = page;
        },

        getCurrentPage: function() {
            return current_page;
        },

        isActivePage: function(page_name) {
            return page_name == current_page;
        },

        getImagePath: function (image_id) {
            let image_path = System.getImagesFolder() + "/" + image_id + System.imageExtension();
        },

        getAudioPath: function (audio_id) {
            let image_path = System.getAudioFolder() + "/" + image_id + System.audioExtension();
        },

        fileExist: function (file_path) {
            return System.isFile(file_path);
        },
        
        close: function () {
            NW.App.closeAllWindows();
            NW.App.quit()
        }
    }
}();

$(function() {
    App.init();
});