let es = require('./es.js');
let en = require('./en.js');

let translate = function () {
    "use strict";

    let get_text = function(idioma, str) {

        let text;
        switch (idioma) {
            case 'es': text = es[str];
                break;
            case 'en': text = en[str];
                break;
            default:
                text = str;
        }

        if (!text) {
            text = str;
        }

        return text;
    };

    return {

        get: function (idioma, str) {
            let texto = get_text(idioma, str);

            let args = Array.prototype.slice.call(arguments, 2);
            for (let i = 0; i < args.length; i++) {
                let regexp = new RegExp('\\{'+i+'\\}', 'gi');
                texto = texto.replace(regexp, args[i]);
            }

            return texto;
        }
    };
}();

module.exports = translate;