let CuadreActivity = function () {
    "use strict";

    let dom = App.getContainerMain();

    let cuadre = {
        fecha: '',
        pagos: [],
        ventas: 0,
        comision: 0,
        premios: 0,
        resultado: 0,
        pagado: 0,
        subtotal: 0,
        saldado: 0,
        total: 0,
        deuda: 0,
        recibos: 0,
        balance: 0,
        recargas: 0,
        recargas_comision: 0,
        total_total: 0
    };

    let initHtml = function () {
        dom.empty();

        let html = '' +
            '<section class="box-typical">' +
            '   <header class="box-typical-header">' +
            '       <div class="tbl-row">' +
            '           <div class="tbl-cell tbl-cell-title col-md-2"><h3>Cuadre</h3></div>' +
            '           <div class="tbl-cell tbl-cell-title col-md-3">' +
            '           </div>' +
            '           <div class="tbl-cell tbl-cell-title col-md-3">' +
            '           </div>' +
            '           <div class="tbl-cell tbl-cell-action-bordered"><button type="button" class="action-btn" id="sorteos-icon-print"><i class="fa fa-print" aria-hidden="true"></i></button></div>' +
            '       </div>' +
            '   </header>' +
            '   <div class="box-typical-body typical-body2">' +
            '       <div class="table-responsive">' +
            '           <table id="table_header" class="table table-bordered tb-no-border" style="font-size: 20px;">' +
            '               <tr><td align="center" id="empresa_nombre" class="font-weight-bold">-</td></tr>' +
            '               <tr><td align="center" id="empresa_eslogan">-</td></tr>' +
            '               <tr><td align="center" id="fecha">-</td></tr>' +
            '               <tr><td align="center" id="vendedor">-</td></tr>' +
            '               <tr><td align="center"><hr></td></tr>' +
            '           </table>' +
            '           <table id="table_loterias" class="table table-bordered tb-no-border" style="font-size: 20px;" data-striped="true">' +
            '               <tr><td align="center" class="font-weight-bold">Resumen por Loterías</td></tr>' +
            '               <tr><td align="center">' +
            '                   <table id="table_loterias_content" class="table table-bordered tb-no-border" style="width: 90%;font-size:20px;" data-striped="true">' +
            '                       <tbody></tbody>' +
            '                   </table>' +
            '               </td></tr>' +
            '               <tr><td align="center"><hr></td></tr>' +
            '           </table>' +
            '           <table class="table table-bordered tb-no-border" data-striped="true" style="font-size:20px;">' +
            '               <tr><td align="center" colspan="2" id="empresa_nombre" class="font-weight-bold">Resumen General</td></tr>' +
            '               <tr><td align="center">' +
            '                   <table class="table table-bordered tb-no-border" style="width:90%;font-size:20px;" data-striped="true">' +
            '                      <tr>' +
                    '                   <td align="left" width="50%">Ventas</td>' +
                    '                   <td align="right" id="resumen_ventas">0</td>' +
                    '               </tr>' +
                    '               <tr>' +
                    '                   <td align="left">Comisión</td>' +
                    '                   <td align="right" id="resumen_comision">0</td>' +
                    '               </tr>' +
                    '               <tr>' +
                    '                   <td align="left">Premios</td>' +
                    '                   <td align="right" id="resumen_premios">0</td>' +
                    '               </tr>' +
                    '               <tr>' +
                    '                   <td align="left">Resultado</td>' +
                    '                   <td align="right" id="resumen_resultado">0</td>' +
                    '               </tr>' +
                    '               <tr id="tr_pago_premios">' +
                    '                   <td align="left">Pagos Premios</td>' +
                    '                   <td align="right" id="resumen_pagado" style="text-decoration:underline;">0</td>' +
                    '               </tr>' +
                    '               <tr id="tr_sub_total">' +
                    '                   <td align="left" class="font-weight-bold">Sub Total</td>' +
                    '                   <td align="right" class="font-weight-bold" id="resumen_subtotal">0</td>' +
                    '               </tr>' +
                    '               <tr>' +
                    '                   <td align="left">Monto Saldado</td>' +
                    '                   <td align="right" id="resumen_saldado" style="text-decoration:underline;">0</td>' +
                    '               </tr>' +
                    '               <tr id="tr_total">' +
                    '                   <td align="left" class="font-weight-bold">Total</td>' +
                    '                   <td align="right" class="font-weight-bold" id="resumen_total">0</td>' +
                    '               </tr>' +
                    '               <tr>' +
                    '                   <td align="left">Deuda Anterior</td>' +
                    '                   <td align="right" id="resumen_deuda">0</td>' +
                    '               </tr>' +
                    '               <tr>' +
                    '                   <td align="left">Pagos Realizados</td>' +
                    '                   <td align="right" id="resumen_recibos" style="text-decoration:underline;">0</td>' +
                    '               </tr>' +
                    '               <tr>' +
                    '                   <td align="left" class="font-weight-bold">BALANCE</td>' +
                    '                   <td align="right" class="font-weight-bold" id="resumen_balance">0</td>' +
                    '               </tr>' +
                    '               <tr>' +
                    '                   <td align="left" class="font-weight-bold">&nbsp;</td>' +
                    '                   <td align="right" class="font-weight-bold" id="resumen_balance">&nbsp;</td>' +
                    '               </tr>' +
            '                   </table>' +
            '               </td></tr>' +
            '           </table>' +
            '           <table id="tabla_recargas" class="table table-bordered tb-no-border" style="display:none;font-size:20px;" data-striped="true">' +
            '               <tr><td align="center" colspan="2" class="font-weight-bold">Recargas</td></tr>' +
            '               <tr><td align="center">' +
            '                   <table class="table table-bordered tb-no-border" style="width: 90%;font-size:20px;" data-striped="true">' +
            '                       <tr>' +
                    '                   <td align="left" width="50%">Recargas</td>' +
                    '                   <td align="right" id="resumen_recargas">0</td>' +
                    '               </tr>' +
                    '               <tr>' +
                    '                   <td align="left">Comisión Recargas</td>' +
                    '                   <td align="right" id="resumen_recargas_comision" style="text-decoration:underline;">0</td>' +
                    '               </tr>' +
                    '               <tr>' +
                    '                   <td align="left" class="font-weight-bold">TOTAL A PAGAR</td>' +
                    '                   <td align="right" class="font-weight-bold" id="resumen_total_total">0</td>' +
                    '               </tr>' +
                    '               <tr>' +
                    '                   <td align="left" class="font-weight-bold">&nbsp;</td>' +
                    '                   <td align="right" class="font-weight-bold" id="resumen_balance">&nbsp;</td>' +
                    '               </tr>' +
            '                   </table>' +
            '               </td></tr>' +
            '           </table>' +
            '       </div>' +
            '   </div>' +
            '</section>';

        dom.append(html);

        $("#daterange_fecha_desde").val(Time.fecha("DD/MM/YYYY"));
        $("#daterange_fecha_hasta").val(Time.fecha("DD/MM/YYYY"));
    }

    let initListener = function () {

        let dateOps = ut.datePikerLocale();
        dateOps.singleDatePicker = true;

        $('#daterange_fecha_desde').daterangepicker(dateOps);
        $('#daterange_fecha_desde').on('hide.daterangepicker', function() {
            initRequest();
        });

        $('#daterange_fecha_hasta').daterangepicker(dateOps);
        $('#daterange_fecha_hasta').on('hide.daterangepicker', function() {
            initRequest();
        });

        $('div').on('click', 'button#sorteos-icon-print', function (e) {
            e.stopPropagation();
            new PrinterCuadre(cuadre).print();
        });
    }

    let initRequest = function () {
        Server.sending({
            'action': packet.CUADRE,
            'fecha_desde': $("#daterange_fecha_desde").val(),
            'fecha_hasta': $("#daterange_fecha_hasta").val(),
        });
    }

    let onData = function (data) { console.log(data)

        let table = dom.find('#table_loterias_content tbody');
        table.empty();

        let resumen_loterias = data.resumen_loterias;
        for (let i=0; i<resumen_loterias.length; i++) {
            let row = resumen_loterias[i]; console.log(row);

            let html = '<tr><td align="center" colspan="4"><br>' + row.loteria + '</td></tr>' +
                '<tr><td align="right" width="30%">Venta:</td><td align="right" ">' + row.ventas + '</td></tr>' +
                '<tr><td align="right" width="30%">Comisión:</td><td align="right" ">' + row.premios + '</td></tr>' +
                '<tr><td align="right" width="30%">Premios:</td><td align="right" ">' + row.comision + '</td></tr>' +
                '<tr><td align="right" width="30%">Balance:</td><td align="right" class="font-weight-bold">' + row.balance + '</td></tr>';

            table.append(html);
        }

        cuadre.fecha = data.fecha;
        cuadre.pagos = data.pagos_premios_list;
        cuadre.ventas = data.ventas;
        cuadre.comision = data.comision;
        cuadre.premios = data.premios;
        cuadre.resultado = data.resultado;
        cuadre.pagado = data.pagos_premios;
        cuadre.subtotal = data.subtotal;
        cuadre.saldado = data.saldado;
        cuadre.total = data.total;
        cuadre.deuda = data.deuda_anterior;
        cuadre.recibos = data.pagos_deudas;
        cuadre.balance = data.balance;
        cuadre.recargas = data.recargas;
        cuadre.recargas_comision = data.recargas_comision;
        cuadre.total_total = data.total_total;

        dom.find('#empresa_nombre').text(Empresa.getNombre());
        dom.find('#empresa_eslogan').text(Empresa.getEslogan());
        dom.find('#fecha').text(cuadre.fecha);
        dom.find('#vendedor').text(Vendedor.getNombre());

        dom.find('#resumen_ventas').text(cuadre.ventas);
        dom.find('#resumen_comision').text(cuadre.comision);
        dom.find('#resumen_premios').text(cuadre.premios);
        dom.find('#resumen_resultado').text(cuadre.resultado);
        dom.find('#resumen_pagado').text(cuadre.pagado);
        dom.find('#resumen_subtotal').text(cuadre.subtotal);
        dom.find('#resumen_saldado').text(cuadre.saldado);
        dom.find('#resumen_total').text(cuadre.total);
        dom.find('#resumen_deuda').text(cuadre.deuda);
        dom.find('#resumen_recibos').text(cuadre.recibos);
        dom.find('#resumen_balance').text(cuadre.balance);
        dom.find('#resumen_recargas').text(cuadre.recargas);
        dom.find('#resumen_recargas_comision').text(cuadre.recargas_comision);
        dom.find('#resumen_total_total').text(cuadre.total_total);

        // si no hay recargas
        if (filter.int(cuadre.recargas) > 0) {
            dom.find('#tabla_recargas').show();
        }
        else {
            dom.find('#tabla_recargas').hide();
        }

        // si no hubo pago premios
        let pagado_box = dom.find('#tr_pago_premios');
        let subtotal_box = dom.find('#tr_sub_total');
        //let total_label = dom.find('#tr_total');

        if  (!cuadre.pagado) {
            pagado_box.hide();
            subtotal_box.hide();
            //total_label.text("Sub Total");
        }
        else {
            pagado_box.show();
            subtotal_box.show();
            //total_label.setText("Total");
        }
    }

    let print = function () {
        new PrinterCuadre(cuadre).print();
    }

    let init = function () {
        if (!App.isActivePage(Co.PAGE_CUADRE)) {
            App.setCurrentPage(Co.PAGE_CUADRE);

            initHtml();


            initListener();
            initRequest();
        }
    }

    return {
        init: init,
        onData: onData,
        print: print
    }
}();