let vChat = function () {
	"use strict";

	let chat_tab = [];

	let tab_opened;
	let tab_friends;
	let tab_usuarios;

	/*Chat.meChat_Strings({
		box_menu_title: 'Messages (0)'
	});*/


// When the chatbox is opened
	Chat.meChat_Event('chat.open', function (chatID, chatDOM) { console.warn("Chat.meChat_Event('chat.open'"); console.trace();
		console.log("main.meChat_Event() chat.open")

		// Build Item chatbox
		let me_chat_string = '';

		me_chat_string += '<div class="chatbox-menu-picture" style="background-image: url(' + Chat.meChat_getProp(chatID, 'picture') + ');"></div>';

		me_chat_string += '<div class="chatbox-menu-info"><div class="chatbox-menu-name">' + Chat.meChat_getProp(chatID, 'name') + '<br><i class="chatbox-menu-lastmessage"></i></div></div>';

		// Add item to tab (Opened)
		let itemID = Chat.addTabAddItem(tab_opened, me_chat_string);

		// Add function to item
		Chat.meChatTab_ItemFunction(itemID, 'click touchstart', function () {
			Chat.openChat(chatID); // Open chatbox
			$('div[data-me-chat-id="' + chatID + '"]').find('textarea').focus(); // Search for chatbox with id and focus on it
		});

		// Sync item with the chatbox
		Chat.meChat_setProp(chatID, 'itemid', itemID);
	});

// When the chatbox is closed
	Chat.meChat_Event('chat.close', function (chatID, chatDOM, chatProp) { console.warn("Chat.meChat_Event('chat.close'")
		//console.log("main.meChat_Event() chat.close")

		// Remove synchronized item from tab (Opened)
		Chat.meChatTab_RemoveItem(chatProp.itemid);
	});


	// show tab
	function showTab(tabID) { console.warn("vChat.showTab(): "+tabID);

		let tab = chat_tab[tabID];
		tab.visibility = true;

		let ul = $('.me-chat-box-manager-content ul');
		ul.empty();

		let keys = Object.keys(tab.items);
		for (let j=0; j<keys.length; j++) {
			let item = tab.items[keys[j]];
			ul.append(item.html);
		}
	};

	let addTab = function (tabName) {

		let tab = {
			id: chat_tab.length,
			tabname: tabName,
			items: {},
			visibility: true,
		};
		chat_tab.push(tab);

		return tab.id;
	}

	//fm agrega item a un tab
	let addTabItem = function (item) { //console.log("addTabItem(): "); console.log(item);console.trace();
		let tabID = 0;
		let tab = chat_tab[tabID];
		tab.items[item.id] = item;

		return item;
	}

	//fm devuelve un item de un tab
	let getTabItem = function (itemID) { //console.log("getTabItem(): " + itemID);
		let tabID = 0;
		let tab = chat_tab[tabID];
		return tab.items[itemID];
	}

	return {
		addTab: addTab,
		addTabItem: addTabItem,
		getItem: function (itemid) {
			return getTabItem(itemid);
		},

		showTab: showTab,

		// se ejecuta cuando el usuario se conecta
		onlines: function (data) {

			let away_u = data.away_u;
			let away_v = data.away_v;

			// usuarios
			let conectados_u = data.conectados_u; //console.log(conectados_u);
			for (let i=0; i<conectados_u.length; i++) {
				if (away_u.indexOf(conectados_u[i]) < 0) {
					this.away(conectados_u[i]);
				}
				else {
					this.online(conectados_u[i]);
				}
			}

			// vendedores
			let conectados_v = data.conectados_v; //console.log(conectados_v);
			for (let i=0; i<conectados_v.length; i++) {
				if (away_v.indexOf(conectados_v[i]) < 0) {
					this.away(conectados_v[i]);
				}
				else {
					this.online(conectados_v[i]);
				}
			}
		},

		online: function (chatID) {
			let item = this.getItem(chatID);
			if (item) { item.setOnline(); }
		},

		away: function (chatID) { console.log("vChat.away() id:" + chatID);
			let item = this.getItem(chatID);
			if (item) { item.setAway(); }
		},

		offline: function (chatID) {
			let item = this.getItem(chatID);
			if (item) { item.setOffline(); }
		},

		/**
		 * Marca a todos los vendedores y usuarios del chat como desconectados
		 * Se ejecuta cuando el el socket se desconecta
		 */
		offlines: function () {
			let chats = Chat.getChats();
			let keys = Object.keys(chats);
			for (let i=0; i<keys.length; i++) {
				this.offline(keys[i]);
			}
		},

		//fm cuenta la cantidad de mensajes sin leer
		// se ejecuta desde Chat.openChat()
		unreadCount: function() { //console.log("vChat.unreadCount()");
			let unread = 0;

			let chat;
			let chats = Chat.getChats();
			let keys = Object.keys(chats);
			for (let i=0; i<keys.length; i++) {
				chat = chats[keys[i]];
				unread += chat.getUnread();

				if (isNaN(chat.getUnread())) {
					console.log(keys[i]);
					console.error(chat);
					console.error(chat.item);
				}
			}

			return unread;
		},

		typing: function (chatID) {
			let chat = Chat.getChat(chatID);
			if (chat) { chat.setTyping(); }

			let item_opened = getTabItem(tab_opened, chatID);
			if (item_opened) { item_opened.setTyping(); }
		},
	}

}();