let ChatItemOpened = function (item) { //console.log("ChatItemOpened()"); console.log(item);

    this.id = item.id; // aqui es necesario

    this.item = item;

    this.html = null;

    this.typing = false;

    this.createHtml();
}

ChatItemOpened.prototype.createHtml = function () {

    let chat_string = '' +
        '<div class="chatbox-menu-picture" style="background-image: url(' + this.item.pic + ');"></div>' +
        '<div class="chatbox-menu-info"><div class="chatbox-menu-name">' + this.item.name + ' (' + this.item.unread + ')<br><i class="chatbox-menu-lastmessage"></i>' + this.item.getLastMessageText() + '</div>' +
        '</div>';

    chat_string = '<li class="me-chat-item-message" data-id="' + this.item.id + '" data-type="' +this.item.type+ '">' + chat_string + '</li>';
    let html = $.parseHTML(chat_string);

    this.html = html;
}

ChatItemOpened.prototype.update = function () { console.log("ChatItemOpened.update");
    let string = this.item.name + ' (' + this.item.unread + ')<br><i class="chatbox-menu-lastmessage"></i>' + this.item.getLastMessageText();
    $(this.html).find('.chatbox-menu-name').html(string);
}

ChatItemOpened.prototype.setTyping = function () { console.log("ChatItemOpened.setTyping");
    if (this.typing !== false) {
        clearTimeout(this.typing);
        this.typing = false;
    }
    let string = this.item.name + ' (' + this.item.unread + ')<br><i class="chatbox-menu-lastmessage"></i> Está escribiendo...';
    $(this.html).find('.chatbox-menu-name').html(string);

    $(this.html).find('.me-chat-box-message-sent-seen').text('Está escribiendo...');

    let self = this;
    this.typing = setTimeout(function () {
        self.update();
    }, 3000);
}