let LoginActivity = function () {

    let dom

    let init = function () { console.log("login.init()");
        App.setCurrentPage(Co.PAGE_LOGIN);

        dom = $('#login-box');

        $('#input-login-pass').val("");

        $('#btn-login').click(function () { console.log("click")
            doLogin();
        });

        $('#input-login-pass').keypress(function (e) {
            if (e.which == 13) {
                doLogin();
            }
        });

        show();

        let ip = Server.getIp(); console.log("ip:"+ip);
        if (!ip) {
            Server.configServer();
        }
    }

    let doLogin = function () {
        let ip = Server.getIp(); console.log("doLogin ip:"+ip);

        let empresa_id = DB.get(DB.EMPRESA_ID); console.log("doLogin empresa_id:"+empresa_id);
        if  (!ip) {
            Server.configEmpresa();
            return;
        }

        let pass = $('#input-login-pass').val().trim();
        let username = $('#input-login-id').val().trim();

        // configurar empresa
        if (pass.length == 8) {
            Server.configEmpresa(pass);
            return;
        }

        if (pass.length != 4) {
            ui.dialogError(_t('invalid_pass'));
            return;
        }

        DB.set(DB.PASSWORD, pass);
        DB.set(DB.USERNAME, username);

        Server.sending({
            action: packet.LOGIN,
            pass: pass,
            username: username
        });
    }

    let autoLogin = function() { console.log("LoginActivity.autoLogin() page:"+App.getCurrentPage());
        if (App.getCurrentPage() === Co.PAGE_LOGIN) {
            return;
        }

        let pass = DB.get(DB.PASSWORD);
        if (pass == null) {
            LoginActivity.init();
            return;
        }

        let username = DB.get(DB.USERNAME);

        Server.send({
            action: packet.AUTOLOGIN,
            pass: pass,
            username: username
        });
    }

    let show = function () {
        dom.css("display", "flex");
    }

    let hide = function () {
        dom.css("display", "none");
    }

    let checkLogo = function (id) { console.log("checkLogo() id:" + id);
        if  (id == "21181") {
            $(".site-logo").find("img").attr("src", "img/logo-mg.png");
        }
        else if  (id == "151328657248175200") {
            $(".site-logo").find("img").attr("src", "img/logo-mg.png");
        }
        else {
            $(".site-logo").find("img").attr("src", "img/logo.png");
        }
    }

    let onResult = function (data) { console.log("onResult()"); console.log(data);
        if (data.success) {
            Empresa.init(data);
            Vendedor.touch(data.data.vendedor);
            Loterias.init(data.data.loterias);
            //VentaActivity.setOptionsIcons();
            VentaActivity.init();
            hide();
            checkLogo(data.data.id);
        }
        else {
            ui.dialogError(data.msg);
        }
    }

    let onAutoLoginResult = function (data) { console.log("onAutoLoginResult()");
        if (data.success) {
            Empresa.init(data);
            Vendedor.touch(data.data.vendedor);
            Loterias.init(data.data.loterias);
            //VentaActivity.setOptionsIcons();
            Chat.start(data.usuarios);
        }
        else {
            LoginActivity.init();
        }
    }

    return {
        init: init,
        doLogin: doLogin,
        autoLogin: autoLogin,
        onAutoLoginResult: onAutoLoginResult,
        show: show,
        hide: hide,
        onResult: onResult,
    }
}();